package org.ccsds.moims.mo.malprototype.iptest.provider;

/**
 * Provider PROGRESS interaction class for IPTest::testProgressEmptyBody operation.
 */
public class TestProgressEmptyBodyInteraction
{
  private org.ccsds.moims.mo.mal.provider.MALProgress interaction;
  /**
   * Wraps the provided MAL interaction object with methods for sending responses to an PROGRESS interaction from a provider.
   * @param interaction interaction The MAL interaction action object to use.
   */
  public TestProgressEmptyBodyInteraction(org.ccsds.moims.mo.mal.provider.MALProgress interaction)
  {
    this.interaction = interaction;
  }

  /**
   * Returns the MAL interaction object used for returning messages from the provider.
   * @return The MAL interaction object provided in the constructor.
   */
  public org.ccsds.moims.mo.mal.provider.MALProgress getInteraction()
  {
    return interaction;
  }

  /**
   * Sends a PROGRESS acknowledge to the consumer.
   * @return Returns the MAL message created by the acknowledge.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendAcknowledgement() throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendAcknowledgement((Object[]) null);
  }

  /**
   * Sends a PROGRESS update to the consumer.
   * @return Returns the MAL message created by the update.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendUpdate() throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendUpdate((Object[]) null);
  }

  /**
   * Sends a PROGRESS response to the consumer.
   * @return Returns the MAL message created by the response.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendResponse() throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendResponse((Object[]) null);
  }

  /**
   * Sends an error to the consumer.
   * @param error error The MAL error to send to the consumer.
   * @return Returns the MAL message created by the error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendError(org.ccsds.moims.mo.mal.MALStandardError error) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendError(error);
  }

  /**
   * Sends an update error to the consumer.
   * @param error error The MAL error to send to the consumer.
   * @return Returns the MAL message created by the error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendUpdateError(org.ccsds.moims.mo.mal.MALStandardError error) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendUpdateError(error);
  }

}
