package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * This data structure is an error report produced after having found a faulty header.
 */
public final class BadHeaderReport implements org.ccsds.moims.mo.mal.structures.Composite
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(4);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810116L);
  private static final long serialVersionUID = 28147501982810116L;
  /**
   * The expected header.
   */
  private org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader expectedHeader;
  /**
   * The header that is not compliant with the MAL rules.
   */
  private org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader faultyHeader;
  /**
   * Default constructor for BadHeaderReport.
   */
  public BadHeaderReport()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param expectedHeader The expected header.
   * @param faultyHeader The header that is not compliant with the MAL rules.
   */
  public BadHeaderReport(org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader expectedHeader, org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader faultyHeader)
  {
    this.expectedHeader = expectedHeader;
    this.faultyHeader = faultyHeader;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.BadHeaderReport();
  }

  /**
   * Returns the field expectedHeader.
   * @return The field expectedHeader.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader getExpectedHeader()
  {
    return expectedHeader;
  }

  /**
   * Sets the field expectedHeader.
   * @param __newValue __newValue The new value.
   */
  public void setExpectedHeader(org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader __newValue)
  {
    expectedHeader = __newValue;
  }

  /**
   * Returns the field faultyHeader.
   * @return The field faultyHeader.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader getFaultyHeader()
  {
    return faultyHeader;
  }

  /**
   * Sets the field faultyHeader.
   * @param __newValue __newValue The new value.
   */
  public void setFaultyHeader(org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader __newValue)
  {
    faultyHeader = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof BadHeaderReport)
    {
      BadHeaderReport other = (BadHeaderReport) obj;
      if (expectedHeader == null)
      {
        if (other.expectedHeader != null)
        {
          return false;
        }
      }
      else
      {
        if (! expectedHeader.equals(other.expectedHeader))
        {
          return false;
        }
      }
      if (faultyHeader == null)
      {
        if (other.faultyHeader != null)
        {
          return false;
        }
      }
      else
      {
        if (! faultyHeader.equals(other.faultyHeader))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = 7;
    hash = 83 * hash + (expectedHeader != null ? expectedHeader.hashCode() : 0);
    hash = 83 * hash + (faultyHeader != null ? faultyHeader.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append("expectedHeader=");
    buf.append(expectedHeader);
    buf.append(", faultyHeader=");
    buf.append(faultyHeader);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    encoder.encodeNullableElement(expectedHeader);
    encoder.encodeNullableElement(faultyHeader);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    expectedHeader = (org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader) decoder.decodeNullableElement(new org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader());
    faultyHeader = (org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader) decoder.decodeNullableElement(new org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader());
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
