package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * This abstract structure is inherited by all the IP test definition structures.
 */
public final class IPTestDefinition implements org.ccsds.moims.mo.mal.structures.Composite
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(2);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810114L);
  private static final long serialVersionUID = 28147501982810114L;
  /**
   * Name of the test procedure.
   */
  private String procedureName;
  /**
   * The consumer's URI.
   */
  private org.ccsds.moims.mo.mal.structures.URI consumerURI;
  /**
   * The authentication identifier used by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.Blob authenticationId;
  /**
   * The QoS level required by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.QoSLevel Qos;
  /**
   * The priority level required by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.UInteger Priority;
  /**
   * The domain used by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.IdentifierList Domain;
  /**
   * The network zone used by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier networkZone;
  /**
   * The type of the session used by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.SessionType Session;
  /**
   * The identifier of the session used by the consumer.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier sessionName;
  /**
   * The transitions that are requested by the consumer.
   */
  private org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList transitions;
  /**
   * The time the consumer initiated the interaction.
   */
  private org.ccsds.moims.mo.mal.structures.Time timestamp;
  /**
   * Default constructor for IPTestDefinition.
   */
  public IPTestDefinition()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param procedureName Name of the test procedure.
   * @param consumerURI The consumer's URI.
   * @param authenticationId The authentication identifier used by the consumer.
   * @param Qos The QoS level required by the consumer.
   * @param Priority The priority level required by the consumer.
   * @param Domain The domain used by the consumer.
   * @param networkZone The network zone used by the consumer.
   * @param Session The type of the session used by the consumer.
   * @param sessionName The identifier of the session used by the consumer.
   * @param transitions The transitions that are requested by the consumer.
   * @param timestamp The time the consumer initiated the interaction.
   */
  public IPTestDefinition(String procedureName, org.ccsds.moims.mo.mal.structures.URI consumerURI, org.ccsds.moims.mo.mal.structures.Blob authenticationId, org.ccsds.moims.mo.mal.structures.QoSLevel Qos, org.ccsds.moims.mo.mal.structures.UInteger Priority, org.ccsds.moims.mo.mal.structures.IdentifierList Domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType Session, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList transitions, org.ccsds.moims.mo.mal.structures.Time timestamp)
  {
    this.procedureName = procedureName;
    this.consumerURI = consumerURI;
    this.authenticationId = authenticationId;
    this.Qos = Qos;
    this.Priority = Priority;
    this.Domain = Domain;
    this.networkZone = networkZone;
    this.Session = Session;
    this.sessionName = sessionName;
    this.transitions = transitions;
    this.timestamp = timestamp;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition();
  }

  /**
   * Returns the field procedureName.
   * @return The field procedureName.
   */
  public String getProcedureName()
  {
    return procedureName;
  }

  /**
   * Sets the field procedureName.
   * @param __newValue __newValue The new value.
   */
  public void setProcedureName(String __newValue)
  {
    procedureName = __newValue;
  }

  /**
   * Returns the field consumerURI.
   * @return The field consumerURI.
   */
  public org.ccsds.moims.mo.mal.structures.URI getConsumerURI()
  {
    return consumerURI;
  }

  /**
   * Sets the field consumerURI.
   * @param __newValue __newValue The new value.
   */
  public void setConsumerURI(org.ccsds.moims.mo.mal.structures.URI __newValue)
  {
    consumerURI = __newValue;
  }

  /**
   * Returns the field authenticationId.
   * @return The field authenticationId.
   */
  public org.ccsds.moims.mo.mal.structures.Blob getAuthenticationId()
  {
    return authenticationId;
  }

  /**
   * Sets the field authenticationId.
   * @param __newValue __newValue The new value.
   */
  public void setAuthenticationId(org.ccsds.moims.mo.mal.structures.Blob __newValue)
  {
    authenticationId = __newValue;
  }

  /**
   * Returns the field Qos.
   * @return The field Qos.
   */
  public org.ccsds.moims.mo.mal.structures.QoSLevel getQos()
  {
    return Qos;
  }

  /**
   * Sets the field Qos.
   * @param __newValue __newValue The new value.
   */
  public void setQos(org.ccsds.moims.mo.mal.structures.QoSLevel __newValue)
  {
    Qos = __newValue;
  }

  /**
   * Returns the field Priority.
   * @return The field Priority.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger getPriority()
  {
    return Priority;
  }

  /**
   * Sets the field Priority.
   * @param __newValue __newValue The new value.
   */
  public void setPriority(org.ccsds.moims.mo.mal.structures.UInteger __newValue)
  {
    Priority = __newValue;
  }

  /**
   * Returns the field Domain.
   * @return The field Domain.
   */
  public org.ccsds.moims.mo.mal.structures.IdentifierList getDomain()
  {
    return Domain;
  }

  /**
   * Sets the field Domain.
   * @param __newValue __newValue The new value.
   */
  public void setDomain(org.ccsds.moims.mo.mal.structures.IdentifierList __newValue)
  {
    Domain = __newValue;
  }

  /**
   * Returns the field networkZone.
   * @return The field networkZone.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getNetworkZone()
  {
    return networkZone;
  }

  /**
   * Sets the field networkZone.
   * @param __newValue __newValue The new value.
   */
  public void setNetworkZone(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    networkZone = __newValue;
  }

  /**
   * Returns the field Session.
   * @return The field Session.
   */
  public org.ccsds.moims.mo.mal.structures.SessionType getSession()
  {
    return Session;
  }

  /**
   * Sets the field Session.
   * @param __newValue __newValue The new value.
   */
  public void setSession(org.ccsds.moims.mo.mal.structures.SessionType __newValue)
  {
    Session = __newValue;
  }

  /**
   * Returns the field sessionName.
   * @return The field sessionName.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getSessionName()
  {
    return sessionName;
  }

  /**
   * Sets the field sessionName.
   * @param __newValue __newValue The new value.
   */
  public void setSessionName(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    sessionName = __newValue;
  }

  /**
   * Returns the field transitions.
   * @return The field transitions.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList getTransitions()
  {
    return transitions;
  }

  /**
   * Sets the field transitions.
   * @param __newValue __newValue The new value.
   */
  public void setTransitions(org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList __newValue)
  {
    transitions = __newValue;
  }

  /**
   * Returns the field timestamp.
   * @return The field timestamp.
   */
  public org.ccsds.moims.mo.mal.structures.Time getTimestamp()
  {
    return timestamp;
  }

  /**
   * Sets the field timestamp.
   * @param __newValue __newValue The new value.
   */
  public void setTimestamp(org.ccsds.moims.mo.mal.structures.Time __newValue)
  {
    timestamp = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof IPTestDefinition)
    {
      IPTestDefinition other = (IPTestDefinition) obj;
      if (procedureName == null)
      {
        if (other.procedureName != null)
        {
          return false;
        }
      }
      else
      {
        if (! procedureName.equals(other.procedureName))
        {
          return false;
        }
      }
      if (consumerURI == null)
      {
        if (other.consumerURI != null)
        {
          return false;
        }
      }
      else
      {
        if (! consumerURI.equals(other.consumerURI))
        {
          return false;
        }
      }
      if (authenticationId == null)
      {
        if (other.authenticationId != null)
        {
          return false;
        }
      }
      else
      {
        if (! authenticationId.equals(other.authenticationId))
        {
          return false;
        }
      }
      if (Qos == null)
      {
        if (other.Qos != null)
        {
          return false;
        }
      }
      else
      {
        if (! Qos.equals(other.Qos))
        {
          return false;
        }
      }
      if (Priority == null)
      {
        if (other.Priority != null)
        {
          return false;
        }
      }
      else
      {
        if (! Priority.equals(other.Priority))
        {
          return false;
        }
      }
      if (Domain == null)
      {
        if (other.Domain != null)
        {
          return false;
        }
      }
      else
      {
        if (! Domain.equals(other.Domain))
        {
          return false;
        }
      }
      if (networkZone == null)
      {
        if (other.networkZone != null)
        {
          return false;
        }
      }
      else
      {
        if (! networkZone.equals(other.networkZone))
        {
          return false;
        }
      }
      if (Session == null)
      {
        if (other.Session != null)
        {
          return false;
        }
      }
      else
      {
        if (! Session.equals(other.Session))
        {
          return false;
        }
      }
      if (sessionName == null)
      {
        if (other.sessionName != null)
        {
          return false;
        }
      }
      else
      {
        if (! sessionName.equals(other.sessionName))
        {
          return false;
        }
      }
      if (transitions == null)
      {
        if (other.transitions != null)
        {
          return false;
        }
      }
      else
      {
        if (! transitions.equals(other.transitions))
        {
          return false;
        }
      }
      if (timestamp == null)
      {
        if (other.timestamp != null)
        {
          return false;
        }
      }
      else
      {
        if (! timestamp.equals(other.timestamp))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = 7;
    hash = 83 * hash + (procedureName != null ? procedureName.hashCode() : 0);
    hash = 83 * hash + (consumerURI != null ? consumerURI.hashCode() : 0);
    hash = 83 * hash + (authenticationId != null ? authenticationId.hashCode() : 0);
    hash = 83 * hash + (Qos != null ? Qos.hashCode() : 0);
    hash = 83 * hash + (Priority != null ? Priority.hashCode() : 0);
    hash = 83 * hash + (Domain != null ? Domain.hashCode() : 0);
    hash = 83 * hash + (networkZone != null ? networkZone.hashCode() : 0);
    hash = 83 * hash + (Session != null ? Session.hashCode() : 0);
    hash = 83 * hash + (sessionName != null ? sessionName.hashCode() : 0);
    hash = 83 * hash + (transitions != null ? transitions.hashCode() : 0);
    hash = 83 * hash + (timestamp != null ? timestamp.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append("procedureName=");
    buf.append(procedureName);
    buf.append(", consumerURI=");
    buf.append(consumerURI);
    buf.append(", authenticationId=");
    buf.append(authenticationId);
    buf.append(", Qos=");
    buf.append(Qos);
    buf.append(", Priority=");
    buf.append(Priority);
    buf.append(", Domain=");
    buf.append(Domain);
    buf.append(", networkZone=");
    buf.append(networkZone);
    buf.append(", Session=");
    buf.append(Session);
    buf.append(", sessionName=");
    buf.append(sessionName);
    buf.append(", transitions=");
    buf.append(transitions);
    buf.append(", timestamp=");
    buf.append(timestamp);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    encoder.encodeNullableString(procedureName);
    encoder.encodeNullableURI(consumerURI);
    encoder.encodeNullableBlob(authenticationId);
    encoder.encodeNullableElement(Qos);
    encoder.encodeNullableUInteger(Priority);
    encoder.encodeNullableElement(Domain);
    encoder.encodeNullableIdentifier(networkZone);
    encoder.encodeNullableElement(Session);
    encoder.encodeNullableIdentifier(sessionName);
    encoder.encodeNullableElement(transitions);
    encoder.encodeNullableTime(timestamp);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    procedureName = decoder.decodeNullableString();
    consumerURI = decoder.decodeNullableURI();
    authenticationId = decoder.decodeNullableBlob();
    Qos = (org.ccsds.moims.mo.mal.structures.QoSLevel) decoder.decodeNullableElement(org.ccsds.moims.mo.mal.structures.QoSLevel.BESTEFFORT);
    Priority = decoder.decodeNullableUInteger();
    Domain = (org.ccsds.moims.mo.mal.structures.IdentifierList) decoder.decodeNullableElement(new org.ccsds.moims.mo.mal.structures.IdentifierList());
    networkZone = decoder.decodeNullableIdentifier();
    Session = (org.ccsds.moims.mo.mal.structures.SessionType) decoder.decodeNullableElement(org.ccsds.moims.mo.mal.structures.SessionType.LIVE);
    sessionName = decoder.decodeNullableIdentifier();
    transitions = (org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList) decoder.decodeNullableElement(new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionList());
    timestamp = decoder.decodeNullableTime();
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
