package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * This structure is used to define an expected transition from an IP test. It asserts what transition is expected and what result is expected from the transition: successful or failure.
 */
public final class IPTestTransition implements org.ccsds.moims.mo.mal.structures.Composite
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(3);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810115L);
  private static final long serialVersionUID = 28147501982810115L;
  /**
   * The type of the transition to do.
   */
  private org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType Type;
  /**
   * The code of the error expected to be raised when doing the transition (failed transition).-1 if no error is expected (successful transition).
   */
  private org.ccsds.moims.mo.mal.structures.UInteger errorCode;
  /**
   * Default constructor for IPTestTransition.
   */
  public IPTestTransition()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param Type The type of the transition to do.
   * @param errorCode The code of the error expected to be raised when doing the transition (failed transition).-1 if no error is expected (successful transition).
   */
  public IPTestTransition(org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType Type, org.ccsds.moims.mo.mal.structures.UInteger errorCode)
  {
    this.Type = Type;
    this.errorCode = errorCode;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransition();
  }

  /**
   * Returns the field Type.
   * @return The field Type.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType getType()
  {
    return Type;
  }

  /**
   * Sets the field Type.
   * @param __newValue __newValue The new value.
   */
  public void setType(org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType __newValue)
  {
    Type = __newValue;
  }

  /**
   * Returns the field errorCode.
   * @return The field errorCode.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger getErrorCode()
  {
    return errorCode;
  }

  /**
   * Sets the field errorCode.
   * @param __newValue __newValue The new value.
   */
  public void setErrorCode(org.ccsds.moims.mo.mal.structures.UInteger __newValue)
  {
    errorCode = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof IPTestTransition)
    {
      IPTestTransition other = (IPTestTransition) obj;
      if (Type == null)
      {
        if (other.Type != null)
        {
          return false;
        }
      }
      else
      {
        if (! Type.equals(other.Type))
        {
          return false;
        }
      }
      if (errorCode == null)
      {
        if (other.errorCode != null)
        {
          return false;
        }
      }
      else
      {
        if (! errorCode.equals(other.errorCode))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = 7;
    hash = 83 * hash + (Type != null ? Type.hashCode() : 0);
    hash = 83 * hash + (errorCode != null ? errorCode.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append("Type=");
    buf.append(Type);
    buf.append(", errorCode=");
    buf.append(errorCode);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    encoder.encodeNullableElement(Type);
    encoder.encodeNullableUInteger(errorCode);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    Type = (org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType) decoder.decodeNullableElement(org.ccsds.moims.mo.malprototype.iptest.structures.IPTestTransitionType.ACK);
    errorCode = decoder.decodeNullableUInteger();
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
