package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * The MessageHeader structure is used to hold all fields that are passed for each message exchanged between a consumer and provider. See 4.1 for more information.
 */
public final class MessageHeader implements org.ccsds.moims.mo.mal.structures.Composite
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(11);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810123L);
  private static final long serialVersionUID = 28147501982810123L;
  /**
   * Message Source URI.
   */
  private org.ccsds.moims.mo.mal.structures.URI URIfrom;
  /**
   * Source Authentication Credentials.
   */
  private org.ccsds.moims.mo.mal.structures.Blob authenticationId;
  /**
   * Message Destination URI.
   */
  private org.ccsds.moims.mo.mal.structures.URI URIto;
  /**
   * Message generation timestamp.
   */
  private org.ccsds.moims.mo.mal.structures.Time timestamp;
  /**
   * The QoS level of the message.
   */
  private org.ccsds.moims.mo.mal.structures.QoSLevel QoSlevel;
  /**
   * The QoS priority of the message.
   */
  private org.ccsds.moims.mo.mal.structures.UInteger priority;
  /**
   * Domain of the message.
   */
  private org.ccsds.moims.mo.mal.structures.IdentifierList domain;
  /**
   * Network zone of the message.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier networkZone;
  /**
   * Type of session of the message.
   */
  private org.ccsds.moims.mo.mal.structures.SessionType session;
  /**
   * Name of the session of the message. Shall be ‘LIVE’ if session type is LIVE.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier sessionName;
  /**
   * Interaction Pattern Type.
   */
  private org.ccsds.moims.mo.mal.structures.InteractionType interactionType;
  /**
   * Interaction Pattern Stage.
   */
  private org.ccsds.moims.mo.mal.structures.UOctet interactionStage;
  /**
   * Unique to consumer.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier transactionId;
  /**
   * Service Area Identifier.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier area;
  /**
   * Service Identifier.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier service;
  /**
   * Service Operation Identifier.
   */
  private org.ccsds.moims.mo.mal.structures.Identifier operation;
  /**
   * Service version.
   */
  private org.ccsds.moims.mo.mal.structures.UOctet version;
  /**
   * True if this is an error message else False.
   */
  private Boolean isError;
  /**
   * Default constructor for MessageHeader.
   */
  public MessageHeader()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param URIfrom Message Source URI.
   * @param authenticationId Source Authentication Credentials.
   * @param URIto Message Destination URI.
   * @param timestamp Message generation timestamp.
   * @param QoSlevel The QoS level of the message.
   * @param priority The QoS priority of the message.
   * @param domain Domain of the message.
   * @param networkZone Network zone of the message.
   * @param session Type of session of the message.
   * @param sessionName Name of the session of the message. Shall be ‘LIVE’ if session type is LIVE.
   * @param interactionType Interaction Pattern Type.
   * @param interactionStage Interaction Pattern Stage.
   * @param transactionId Unique to consumer.
   * @param area Service Area Identifier.
   * @param service Service Identifier.
   * @param operation Service Operation Identifier.
   * @param version Service version.
   * @param isError True if this is an error message else False.
   */
  public MessageHeader(org.ccsds.moims.mo.mal.structures.URI URIfrom, org.ccsds.moims.mo.mal.structures.Blob authenticationId, org.ccsds.moims.mo.mal.structures.URI URIto, org.ccsds.moims.mo.mal.structures.Time timestamp, org.ccsds.moims.mo.mal.structures.QoSLevel QoSlevel, org.ccsds.moims.mo.mal.structures.UInteger priority, org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType session, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.InteractionType interactionType, org.ccsds.moims.mo.mal.structures.UOctet interactionStage, org.ccsds.moims.mo.mal.structures.Identifier transactionId, org.ccsds.moims.mo.mal.structures.Identifier area, org.ccsds.moims.mo.mal.structures.Identifier service, org.ccsds.moims.mo.mal.structures.Identifier operation, org.ccsds.moims.mo.mal.structures.UOctet version, Boolean isError)
  {
    this.URIfrom = URIfrom;
    this.authenticationId = authenticationId;
    this.URIto = URIto;
    this.timestamp = timestamp;
    this.QoSlevel = QoSlevel;
    this.priority = priority;
    this.domain = domain;
    this.networkZone = networkZone;
    this.session = session;
    this.sessionName = sessionName;
    this.interactionType = interactionType;
    this.interactionStage = interactionStage;
    this.transactionId = transactionId;
    this.area = area;
    this.service = service;
    this.operation = operation;
    this.version = version;
    this.isError = isError;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.MessageHeader();
  }

  /**
   * Returns the field URIfrom.
   * @return The field URIfrom.
   */
  public org.ccsds.moims.mo.mal.structures.URI getURIfrom()
  {
    return URIfrom;
  }

  /**
   * Sets the field URIfrom.
   * @param __newValue __newValue The new value.
   */
  public void setURIfrom(org.ccsds.moims.mo.mal.structures.URI __newValue)
  {
    URIfrom = __newValue;
  }

  /**
   * Returns the field authenticationId.
   * @return The field authenticationId.
   */
  public org.ccsds.moims.mo.mal.structures.Blob getAuthenticationId()
  {
    return authenticationId;
  }

  /**
   * Sets the field authenticationId.
   * @param __newValue __newValue The new value.
   */
  public void setAuthenticationId(org.ccsds.moims.mo.mal.structures.Blob __newValue)
  {
    authenticationId = __newValue;
  }

  /**
   * Returns the field URIto.
   * @return The field URIto.
   */
  public org.ccsds.moims.mo.mal.structures.URI getURIto()
  {
    return URIto;
  }

  /**
   * Sets the field URIto.
   * @param __newValue __newValue The new value.
   */
  public void setURIto(org.ccsds.moims.mo.mal.structures.URI __newValue)
  {
    URIto = __newValue;
  }

  /**
   * Returns the field timestamp.
   * @return The field timestamp.
   */
  public org.ccsds.moims.mo.mal.structures.Time getTimestamp()
  {
    return timestamp;
  }

  /**
   * Sets the field timestamp.
   * @param __newValue __newValue The new value.
   */
  public void setTimestamp(org.ccsds.moims.mo.mal.structures.Time __newValue)
  {
    timestamp = __newValue;
  }

  /**
   * Returns the field QoSlevel.
   * @return The field QoSlevel.
   */
  public org.ccsds.moims.mo.mal.structures.QoSLevel getQoSlevel()
  {
    return QoSlevel;
  }

  /**
   * Sets the field QoSlevel.
   * @param __newValue __newValue The new value.
   */
  public void setQoSlevel(org.ccsds.moims.mo.mal.structures.QoSLevel __newValue)
  {
    QoSlevel = __newValue;
  }

  /**
   * Returns the field priority.
   * @return The field priority.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger getPriority()
  {
    return priority;
  }

  /**
   * Sets the field priority.
   * @param __newValue __newValue The new value.
   */
  public void setPriority(org.ccsds.moims.mo.mal.structures.UInteger __newValue)
  {
    priority = __newValue;
  }

  /**
   * Returns the field domain.
   * @return The field domain.
   */
  public org.ccsds.moims.mo.mal.structures.IdentifierList getDomain()
  {
    return domain;
  }

  /**
   * Sets the field domain.
   * @param __newValue __newValue The new value.
   */
  public void setDomain(org.ccsds.moims.mo.mal.structures.IdentifierList __newValue)
  {
    domain = __newValue;
  }

  /**
   * Returns the field networkZone.
   * @return The field networkZone.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getNetworkZone()
  {
    return networkZone;
  }

  /**
   * Sets the field networkZone.
   * @param __newValue __newValue The new value.
   */
  public void setNetworkZone(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    networkZone = __newValue;
  }

  /**
   * Returns the field session.
   * @return The field session.
   */
  public org.ccsds.moims.mo.mal.structures.SessionType getSession()
  {
    return session;
  }

  /**
   * Sets the field session.
   * @param __newValue __newValue The new value.
   */
  public void setSession(org.ccsds.moims.mo.mal.structures.SessionType __newValue)
  {
    session = __newValue;
  }

  /**
   * Returns the field sessionName.
   * @return The field sessionName.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getSessionName()
  {
    return sessionName;
  }

  /**
   * Sets the field sessionName.
   * @param __newValue __newValue The new value.
   */
  public void setSessionName(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    sessionName = __newValue;
  }

  /**
   * Returns the field interactionType.
   * @return The field interactionType.
   */
  public org.ccsds.moims.mo.mal.structures.InteractionType getInteractionType()
  {
    return interactionType;
  }

  /**
   * Sets the field interactionType.
   * @param __newValue __newValue The new value.
   */
  public void setInteractionType(org.ccsds.moims.mo.mal.structures.InteractionType __newValue)
  {
    interactionType = __newValue;
  }

  /**
   * Returns the field interactionStage.
   * @return The field interactionStage.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getInteractionStage()
  {
    return interactionStage;
  }

  /**
   * Sets the field interactionStage.
   * @param __newValue __newValue The new value.
   */
  public void setInteractionStage(org.ccsds.moims.mo.mal.structures.UOctet __newValue)
  {
    interactionStage = __newValue;
  }

  /**
   * Returns the field transactionId.
   * @return The field transactionId.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getTransactionId()
  {
    return transactionId;
  }

  /**
   * Sets the field transactionId.
   * @param __newValue __newValue The new value.
   */
  public void setTransactionId(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    transactionId = __newValue;
  }

  /**
   * Returns the field area.
   * @return The field area.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getArea()
  {
    return area;
  }

  /**
   * Sets the field area.
   * @param __newValue __newValue The new value.
   */
  public void setArea(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    area = __newValue;
  }

  /**
   * Returns the field service.
   * @return The field service.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getService()
  {
    return service;
  }

  /**
   * Sets the field service.
   * @param __newValue __newValue The new value.
   */
  public void setService(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    service = __newValue;
  }

  /**
   * Returns the field operation.
   * @return The field operation.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier getOperation()
  {
    return operation;
  }

  /**
   * Sets the field operation.
   * @param __newValue __newValue The new value.
   */
  public void setOperation(org.ccsds.moims.mo.mal.structures.Identifier __newValue)
  {
    operation = __newValue;
  }

  /**
   * Returns the field version.
   * @return The field version.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getVersion()
  {
    return version;
  }

  /**
   * Sets the field version.
   * @param __newValue __newValue The new value.
   */
  public void setVersion(org.ccsds.moims.mo.mal.structures.UOctet __newValue)
  {
    version = __newValue;
  }

  /**
   * Returns the field isError.
   * @return The field isError.
   */
  public Boolean getIsError()
  {
    return isError;
  }

  /**
   * Sets the field isError.
   * @param __newValue __newValue The new value.
   */
  public void setError(Boolean __newValue)
  {
    isError = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof MessageHeader)
    {
      MessageHeader other = (MessageHeader) obj;
      if (URIfrom == null)
      {
        if (other.URIfrom != null)
        {
          return false;
        }
      }
      else
      {
        if (! URIfrom.equals(other.URIfrom))
        {
          return false;
        }
      }
      if (authenticationId == null)
      {
        if (other.authenticationId != null)
        {
          return false;
        }
      }
      else
      {
        if (! authenticationId.equals(other.authenticationId))
        {
          return false;
        }
      }
      if (URIto == null)
      {
        if (other.URIto != null)
        {
          return false;
        }
      }
      else
      {
        if (! URIto.equals(other.URIto))
        {
          return false;
        }
      }
      if (timestamp == null)
      {
        if (other.timestamp != null)
        {
          return false;
        }
      }
      else
      {
        if (! timestamp.equals(other.timestamp))
        {
          return false;
        }
      }
      if (QoSlevel == null)
      {
        if (other.QoSlevel != null)
        {
          return false;
        }
      }
      else
      {
        if (! QoSlevel.equals(other.QoSlevel))
        {
          return false;
        }
      }
      if (priority == null)
      {
        if (other.priority != null)
        {
          return false;
        }
      }
      else
      {
        if (! priority.equals(other.priority))
        {
          return false;
        }
      }
      if (domain == null)
      {
        if (other.domain != null)
        {
          return false;
        }
      }
      else
      {
        if (! domain.equals(other.domain))
        {
          return false;
        }
      }
      if (networkZone == null)
      {
        if (other.networkZone != null)
        {
          return false;
        }
      }
      else
      {
        if (! networkZone.equals(other.networkZone))
        {
          return false;
        }
      }
      if (session == null)
      {
        if (other.session != null)
        {
          return false;
        }
      }
      else
      {
        if (! session.equals(other.session))
        {
          return false;
        }
      }
      if (sessionName == null)
      {
        if (other.sessionName != null)
        {
          return false;
        }
      }
      else
      {
        if (! sessionName.equals(other.sessionName))
        {
          return false;
        }
      }
      if (interactionType == null)
      {
        if (other.interactionType != null)
        {
          return false;
        }
      }
      else
      {
        if (! interactionType.equals(other.interactionType))
        {
          return false;
        }
      }
      if (interactionStage == null)
      {
        if (other.interactionStage != null)
        {
          return false;
        }
      }
      else
      {
        if (! interactionStage.equals(other.interactionStage))
        {
          return false;
        }
      }
      if (transactionId == null)
      {
        if (other.transactionId != null)
        {
          return false;
        }
      }
      else
      {
        if (! transactionId.equals(other.transactionId))
        {
          return false;
        }
      }
      if (area == null)
      {
        if (other.area != null)
        {
          return false;
        }
      }
      else
      {
        if (! area.equals(other.area))
        {
          return false;
        }
      }
      if (service == null)
      {
        if (other.service != null)
        {
          return false;
        }
      }
      else
      {
        if (! service.equals(other.service))
        {
          return false;
        }
      }
      if (operation == null)
      {
        if (other.operation != null)
        {
          return false;
        }
      }
      else
      {
        if (! operation.equals(other.operation))
        {
          return false;
        }
      }
      if (version == null)
      {
        if (other.version != null)
        {
          return false;
        }
      }
      else
      {
        if (! version.equals(other.version))
        {
          return false;
        }
      }
      if (isError == null)
      {
        if (other.isError != null)
        {
          return false;
        }
      }
      else
      {
        if (! isError.equals(other.isError))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = 7;
    hash = 83 * hash + (URIfrom != null ? URIfrom.hashCode() : 0);
    hash = 83 * hash + (authenticationId != null ? authenticationId.hashCode() : 0);
    hash = 83 * hash + (URIto != null ? URIto.hashCode() : 0);
    hash = 83 * hash + (timestamp != null ? timestamp.hashCode() : 0);
    hash = 83 * hash + (QoSlevel != null ? QoSlevel.hashCode() : 0);
    hash = 83 * hash + (priority != null ? priority.hashCode() : 0);
    hash = 83 * hash + (domain != null ? domain.hashCode() : 0);
    hash = 83 * hash + (networkZone != null ? networkZone.hashCode() : 0);
    hash = 83 * hash + (session != null ? session.hashCode() : 0);
    hash = 83 * hash + (sessionName != null ? sessionName.hashCode() : 0);
    hash = 83 * hash + (interactionType != null ? interactionType.hashCode() : 0);
    hash = 83 * hash + (interactionStage != null ? interactionStage.hashCode() : 0);
    hash = 83 * hash + (transactionId != null ? transactionId.hashCode() : 0);
    hash = 83 * hash + (area != null ? area.hashCode() : 0);
    hash = 83 * hash + (service != null ? service.hashCode() : 0);
    hash = 83 * hash + (operation != null ? operation.hashCode() : 0);
    hash = 83 * hash + (version != null ? version.hashCode() : 0);
    hash = 83 * hash + (isError != null ? isError.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append("URIfrom=");
    buf.append(URIfrom);
    buf.append(", authenticationId=");
    buf.append(authenticationId);
    buf.append(", URIto=");
    buf.append(URIto);
    buf.append(", timestamp=");
    buf.append(timestamp);
    buf.append(", QoSlevel=");
    buf.append(QoSlevel);
    buf.append(", priority=");
    buf.append(priority);
    buf.append(", domain=");
    buf.append(domain);
    buf.append(", networkZone=");
    buf.append(networkZone);
    buf.append(", session=");
    buf.append(session);
    buf.append(", sessionName=");
    buf.append(sessionName);
    buf.append(", interactionType=");
    buf.append(interactionType);
    buf.append(", interactionStage=");
    buf.append(interactionStage);
    buf.append(", transactionId=");
    buf.append(transactionId);
    buf.append(", area=");
    buf.append(area);
    buf.append(", service=");
    buf.append(service);
    buf.append(", operation=");
    buf.append(operation);
    buf.append(", version=");
    buf.append(version);
    buf.append(", isError=");
    buf.append(isError);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    encoder.encodeNullableURI(URIfrom);
    encoder.encodeNullableBlob(authenticationId);
    encoder.encodeNullableURI(URIto);
    encoder.encodeNullableTime(timestamp);
    encoder.encodeNullableElement(QoSlevel);
    encoder.encodeNullableUInteger(priority);
    encoder.encodeNullableElement(domain);
    encoder.encodeNullableIdentifier(networkZone);
    encoder.encodeNullableElement(session);
    encoder.encodeNullableIdentifier(sessionName);
    encoder.encodeNullableElement(interactionType);
    encoder.encodeNullableUOctet(interactionStage);
    encoder.encodeNullableIdentifier(transactionId);
    encoder.encodeNullableIdentifier(area);
    encoder.encodeNullableIdentifier(service);
    encoder.encodeNullableIdentifier(operation);
    encoder.encodeNullableUOctet(version);
    encoder.encodeNullableBoolean(isError);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    URIfrom = decoder.decodeNullableURI();
    authenticationId = decoder.decodeNullableBlob();
    URIto = decoder.decodeNullableURI();
    timestamp = decoder.decodeNullableTime();
    QoSlevel = (org.ccsds.moims.mo.mal.structures.QoSLevel) decoder.decodeNullableElement(org.ccsds.moims.mo.mal.structures.QoSLevel.BESTEFFORT);
    priority = decoder.decodeNullableUInteger();
    domain = (org.ccsds.moims.mo.mal.structures.IdentifierList) decoder.decodeNullableElement(new org.ccsds.moims.mo.mal.structures.IdentifierList());
    networkZone = decoder.decodeNullableIdentifier();
    session = (org.ccsds.moims.mo.mal.structures.SessionType) decoder.decodeNullableElement(org.ccsds.moims.mo.mal.structures.SessionType.LIVE);
    sessionName = decoder.decodeNullableIdentifier();
    interactionType = (org.ccsds.moims.mo.mal.structures.InteractionType) decoder.decodeNullableElement(org.ccsds.moims.mo.mal.structures.InteractionType.SEND);
    interactionStage = decoder.decodeNullableUOctet();
    transactionId = decoder.decodeNullableIdentifier();
    area = decoder.decodeNullableIdentifier();
    service = decoder.decodeNullableIdentifier();
    operation = decoder.decodeNullableIdentifier();
    version = decoder.decodeNullableUOctet();
    isError = decoder.decodeNullableBoolean();
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
