package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * This data structure specifies how the IPTest provider shall register.
 */
public final class TestPublishDeregister extends org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(6);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810118L);
  private static final long serialVersionUID = 28147501982810118L;
  /**
   * The keys of the entities to be registered.
   */
  private org.ccsds.moims.mo.mal.structures.EntityKeyList entityKeys;
  /**
   * The code of the Publish Deregister error expected to be received.-1 if no Publish Deregister error is expected.
   */
  private org.ccsds.moims.mo.mal.structures.UInteger errorCode;
  /**
   * Default constructor for TestPublishDeregister.
   */
  public TestPublishDeregister()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param Qos The QoS level to be used by the provider.
   * @param Priority The priority to be used by the provider.
   * @param domain The domain to be used by the provider.
   * @param networkZone The network zone to be used by the provider.
   * @param Session The session type to be used by the provider.
   * @param sessionName The session name to be used by the provider.
   * @param testMultiType Whether to use the multi type version of the PubSub operation.
   * @param entityKeys The keys of the entities to be registered.
   * @param errorCode The code of the Publish Deregister error expected to be received.-1 if no Publish Deregister error is expected.
   */
  public TestPublishDeregister(org.ccsds.moims.mo.mal.structures.QoSLevel Qos, org.ccsds.moims.mo.mal.structures.UInteger Priority, org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType Session, org.ccsds.moims.mo.mal.structures.Identifier sessionName, Boolean testMultiType, org.ccsds.moims.mo.mal.structures.EntityKeyList entityKeys, org.ccsds.moims.mo.mal.structures.UInteger errorCode)
  {
    super(Qos, Priority, domain, networkZone, Session, sessionName, testMultiType);
    this.entityKeys = entityKeys;
    this.errorCode = errorCode;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishDeregister();
  }

  /**
   * Returns the field entityKeys.
   * @return The field entityKeys.
   */
  public org.ccsds.moims.mo.mal.structures.EntityKeyList getEntityKeys()
  {
    return entityKeys;
  }

  /**
   * Sets the field entityKeys.
   * @param __newValue __newValue The new value.
   */
  public void setEntityKeys(org.ccsds.moims.mo.mal.structures.EntityKeyList __newValue)
  {
    entityKeys = __newValue;
  }

  /**
   * Returns the field errorCode.
   * @return The field errorCode.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger getErrorCode()
  {
    return errorCode;
  }

  /**
   * Sets the field errorCode.
   * @param __newValue __newValue The new value.
   */
  public void setErrorCode(org.ccsds.moims.mo.mal.structures.UInteger __newValue)
  {
    errorCode = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof TestPublishDeregister)
    {
      if (! super.equals(obj))
      {
        return false;
      }
      TestPublishDeregister other = (TestPublishDeregister) obj;
      if (entityKeys == null)
      {
        if (other.entityKeys != null)
        {
          return false;
        }
      }
      else
      {
        if (! entityKeys.equals(other.entityKeys))
        {
          return false;
        }
      }
      if (errorCode == null)
      {
        if (other.errorCode != null)
        {
          return false;
        }
      }
      else
      {
        if (! errorCode.equals(other.errorCode))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = super.hashCode();
    hash = 83 * hash + (entityKeys != null ? entityKeys.hashCode() : 0);
    hash = 83 * hash + (errorCode != null ? errorCode.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append(super.toString());
    buf.append(", entityKeys=");
    buf.append(entityKeys);
    buf.append(", errorCode=");
    buf.append(errorCode);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    super.encode(encoder);
    encoder.encodeNullableElement(entityKeys);
    encoder.encodeNullableUInteger(errorCode);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    super.decode(decoder);
    entityKeys = (org.ccsds.moims.mo.mal.structures.EntityKeyList) decoder.decodeNullableElement(new org.ccsds.moims.mo.mal.structures.EntityKeyList());
    errorCode = decoder.decodeNullableUInteger();
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
