package org.ccsds.moims.mo.malprototype.iptest.structures;

/**
 * This data structure specifies how the IPTest provider shall publish an update.
 */
public final class TestPublishUpdate extends org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(7);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(1);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147501982810119L);
  private static final long serialVersionUID = 28147501982810119L;
  /**
   * The headers of the updates to be published by the provider.
   */
  private org.ccsds.moims.mo.mal.structures.UpdateHeaderList updateHeaders;
  /**
   * The updates to be published by the provider.
   */
  private org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList updates;
  /**
   * The code of the Publish error expected to be received.-1 if no Publish error is expected.
   */
  private org.ccsds.moims.mo.mal.structures.UInteger errorCode;
  /**
   * Indicates whether the error is returned as an Exception or a Publish Error message.
   */
  private Boolean isException;
  /**
   * The keys of the published entities that have not been registered.
   */
  private org.ccsds.moims.mo.mal.structures.EntityKeyList failedEntityKeys;
  /**
   * Default constructor for TestPublishUpdate.
   */
  public TestPublishUpdate()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param Qos The QoS level to be used by the provider.
   * @param Priority The priority to be used by the provider.
   * @param domain The domain to be used by the provider.
   * @param networkZone The network zone to be used by the provider.
   * @param Session The session type to be used by the provider.
   * @param sessionName The session name to be used by the provider.
   * @param testMultiType Whether to use the multi type version of the PubSub operation.
   * @param updateHeaders The headers of the updates to be published by the provider.
   * @param updates The updates to be published by the provider.
   * @param errorCode The code of the Publish error expected to be received.-1 if no Publish error is expected.
   * @param isException Indicates whether the error is returned as an Exception or a Publish Error message.
   * @param failedEntityKeys The keys of the published entities that have not been registered.
   */
  public TestPublishUpdate(org.ccsds.moims.mo.mal.structures.QoSLevel Qos, org.ccsds.moims.mo.mal.structures.UInteger Priority, org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType Session, org.ccsds.moims.mo.mal.structures.Identifier sessionName, Boolean testMultiType, org.ccsds.moims.mo.mal.structures.UpdateHeaderList updateHeaders, org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList updates, org.ccsds.moims.mo.mal.structures.UInteger errorCode, Boolean isException, org.ccsds.moims.mo.mal.structures.EntityKeyList failedEntityKeys)
  {
    super(Qos, Priority, domain, networkZone, Session, sessionName, testMultiType);
    this.updateHeaders = updateHeaders;
    this.updates = updates;
    this.errorCode = errorCode;
    this.isException = isException;
    this.failedEntityKeys = failedEntityKeys;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate();
  }

  /**
   * Returns the field updateHeaders.
   * @return The field updateHeaders.
   */
  public org.ccsds.moims.mo.mal.structures.UpdateHeaderList getUpdateHeaders()
  {
    return updateHeaders;
  }

  /**
   * Sets the field updateHeaders.
   * @param __newValue __newValue The new value.
   */
  public void setUpdateHeaders(org.ccsds.moims.mo.mal.structures.UpdateHeaderList __newValue)
  {
    updateHeaders = __newValue;
  }

  /**
   * Returns the field updates.
   * @return The field updates.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList getUpdates()
  {
    return updates;
  }

  /**
   * Sets the field updates.
   * @param __newValue __newValue The new value.
   */
  public void setUpdates(org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList __newValue)
  {
    updates = __newValue;
  }

  /**
   * Returns the field errorCode.
   * @return The field errorCode.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger getErrorCode()
  {
    return errorCode;
  }

  /**
   * Sets the field errorCode.
   * @param __newValue __newValue The new value.
   */
  public void setErrorCode(org.ccsds.moims.mo.mal.structures.UInteger __newValue)
  {
    errorCode = __newValue;
  }

  /**
   * Returns the field isException.
   * @return The field isException.
   */
  public Boolean getIsException()
  {
    return isException;
  }

  /**
   * Sets the field isException.
   * @param __newValue __newValue The new value.
   */
  public void setException(Boolean __newValue)
  {
    isException = __newValue;
  }

  /**
   * Returns the field failedEntityKeys.
   * @return The field failedEntityKeys.
   */
  public org.ccsds.moims.mo.mal.structures.EntityKeyList getFailedEntityKeys()
  {
    return failedEntityKeys;
  }

  /**
   * Sets the field failedEntityKeys.
   * @param __newValue __newValue The new value.
   */
  public void setFailedEntityKeys(org.ccsds.moims.mo.mal.structures.EntityKeyList __newValue)
  {
    failedEntityKeys = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof TestPublishUpdate)
    {
      if (! super.equals(obj))
      {
        return false;
      }
      TestPublishUpdate other = (TestPublishUpdate) obj;
      if (updateHeaders == null)
      {
        if (other.updateHeaders != null)
        {
          return false;
        }
      }
      else
      {
        if (! updateHeaders.equals(other.updateHeaders))
        {
          return false;
        }
      }
      if (updates == null)
      {
        if (other.updates != null)
        {
          return false;
        }
      }
      else
      {
        if (! updates.equals(other.updates))
        {
          return false;
        }
      }
      if (errorCode == null)
      {
        if (other.errorCode != null)
        {
          return false;
        }
      }
      else
      {
        if (! errorCode.equals(other.errorCode))
        {
          return false;
        }
      }
      if (isException == null)
      {
        if (other.isException != null)
        {
          return false;
        }
      }
      else
      {
        if (! isException.equals(other.isException))
        {
          return false;
        }
      }
      if (failedEntityKeys == null)
      {
        if (other.failedEntityKeys != null)
        {
          return false;
        }
      }
      else
      {
        if (! failedEntityKeys.equals(other.failedEntityKeys))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = super.hashCode();
    hash = 83 * hash + (updateHeaders != null ? updateHeaders.hashCode() : 0);
    hash = 83 * hash + (updates != null ? updates.hashCode() : 0);
    hash = 83 * hash + (errorCode != null ? errorCode.hashCode() : 0);
    hash = 83 * hash + (isException != null ? isException.hashCode() : 0);
    hash = 83 * hash + (failedEntityKeys != null ? failedEntityKeys.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append(super.toString());
    buf.append(", updateHeaders=");
    buf.append(updateHeaders);
    buf.append(", updates=");
    buf.append(updates);
    buf.append(", errorCode=");
    buf.append(errorCode);
    buf.append(", isException=");
    buf.append(isException);
    buf.append(", failedEntityKeys=");
    buf.append(failedEntityKeys);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    super.encode(encoder);
    encoder.encodeNullableElement(updateHeaders);
    encoder.encodeNullableElement(updates);
    encoder.encodeNullableUInteger(errorCode);
    encoder.encodeNullableBoolean(isException);
    encoder.encodeNullableElement(failedEntityKeys);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    super.decode(decoder);
    updateHeaders = (org.ccsds.moims.mo.mal.structures.UpdateHeaderList) decoder.decodeNullableElement(new org.ccsds.moims.mo.mal.structures.UpdateHeaderList());
    updates = (org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList) decoder.decodeNullableElement(new org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList());
    errorCode = decoder.decodeNullableUInteger();
    isException = decoder.decodeNullableBoolean();
    failedEntityKeys = (org.ccsds.moims.mo.mal.structures.EntityKeyList) decoder.decodeNullableElement(new org.ccsds.moims.mo.mal.structures.EntityKeyList());
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
