package org.ccsds.moims.mo.malprototype.iptest2.consumer;

/**
 * Consumer adapter for IPTest2 service.
 */
public abstract class IPTest2Adapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter
{
  /**
   * Called by the MAL when a PubSub register acknowledgement is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement error is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub deregister acknowledgement is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @param _UpdateHeaderList1 _UpdateHeaderList1 Argument number 1 as defined by the service operation.
   * @param _TestUpdateList2 _TestUpdateList2 Argument number 2 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Identifier _Identifier0, org.ccsds.moims.mo.mal.structures.UpdateHeaderList _UpdateHeaderList1, org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList _TestUpdateList2, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update error is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishUpdates.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishUpdatesAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishUpdates.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishUpdatesErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishRegister.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishRegister.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishDeregister.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishDeregister.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishDeregisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation testMultipleNotify.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMultipleNotifyAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation testMultipleNotify.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMultipleNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdatesAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHREGISTER_OP_NUMBER:
        publishRegisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotifyAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdatesErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHREGISTER_OP_NUMBER:
        publishRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void registerAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._MONITOR_OP_NUMBER:
        monitorRegisterAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement error is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void registerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._MONITOR_OP_NUMBER:
        monitorRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub update is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void notifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALNotifyBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    if ((org.ccsds.moims.mo.malprototype.MALPrototypeHelper.MALPROTOTYPE_AREA_NUMBER.equals(msgHeader.getServiceArea())) && (org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper.IPTEST2_SERVICE_NUMBER.equals(msgHeader.getService())))
    {
      switch (msgHeader.getOperation().getValue())
      {
        case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._MONITOR_OP_NUMBER:
          monitorNotifyReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()), (org.ccsds.moims.mo.mal.structures.UpdateHeaderList) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeaderList()), (org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList) body.getBodyElement(2, new org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList()), qosProperties);
          break;
        default:
          throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
      }
    }
    else
    {
      notifyReceivedFromOtherService(msgHeader, body, qosProperties);
    }
  }

  /**
   * Called by the MAL when a PubSub update error is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void notifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._MONITOR_OP_NUMBER:
        monitorNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub deregister acknowledgement is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void deregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._MONITOR_OP_NUMBER:
        monitorDeregisterAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub update from another service is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public void notifyReceivedFromOtherService(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALNotifyBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
  }

}
