package org.ccsds.moims.mo.malprototype.iptest2.provider;

/**
 * Provider Inheritance skeleton for IPTest2InheritanceSkeleton service.
 */
public abstract class IPTest2InheritanceSkeleton implements org.ccsds.moims.mo.mal.provider.MALInteractionHandler, org.ccsds.moims.mo.malprototype.iptest2.provider.IPTest2Skeleton, org.ccsds.moims.mo.malprototype.iptest2.provider.IPTest2Handler
{
  private org.ccsds.moims.mo.mal.provider.MALProviderSet providerSet = new org.ccsds.moims.mo.mal.provider.MALProviderSet(org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper.IPTEST2_SERVICE);
  /**
   * Implements the setSkeleton method of the handler interface but does nothing as this is the skeleton.
   * @param skeleton skeleton Not used in the inheritance pattern (the skeleton is 'this'.
   */
  public void setSkeleton(org.ccsds.moims.mo.malprototype.iptest2.provider.IPTest2Skeleton skeleton)
  {
    // Not used in the inheritance pattern (the skeleton is 'this');
  }

  /**
   * Adds the supplied MAL provider to the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malInitialize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.addProvider(provider);
  }

  /**
   * Removes the supplied MAL provider from the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malFinalize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.removeProvider(provider);
  }

  /**
   * Creates a publisher object using the current registered provider set for the PubSub operation monitor.
   * @param domain domain the domain used for publishing.
   * @param networkZone networkZone the network zone used for publishing.
   * @param sessionType sessionType the session used for publishing.
   * @param sessionName sessionName the session name used for publishing.
   * @param qos qos the QoS used for publishing.
   * @param qosProps qosProps the QoS properties used for publishing.
   * @param priority priority the priority used for publishing.
   * @return The new publisher object.
   * @throws org.ccsds.moims.mo.mal.MALException if a problem is detected during creation of the publisher.
   */
  public org.ccsds.moims.mo.malprototype.iptest2.provider.MonitorPublisher createMonitorPublisher(org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType sessionType, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.QoSLevel qos, java.util.Map qosProps, org.ccsds.moims.mo.mal.structures.UInteger priority) throws org.ccsds.moims.mo.mal.MALException
  {
    return new org.ccsds.moims.mo.malprototype.iptest2.provider.MonitorPublisher(providerSet.createPublisherSet(org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper.MONITOR_OP, domain, networkZone, sessionType, sessionName, qos, qosProps, priority));
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSend(org.ccsds.moims.mo.mal.provider.MALInteraction interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSubmit(org.ccsds.moims.mo.mal.provider.MALSubmit interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdates((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHREGISTER_OP_NUMBER:
        publishRegister((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishRegister) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishRegister()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregister((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishDeregister) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishDeregister()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest2.IPTest2Helper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotify((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate()), interaction);
        interaction.sendAcknowledgement();
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleRequest(org.ccsds.moims.mo.mal.provider.MALRequest interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleInvoke(org.ccsds.moims.mo.mal.provider.MALInvoke interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleProgress(org.ccsds.moims.mo.mal.provider.MALProgress interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

}
