package org.ccsds.moims.mo.malprototype.structures;
public final class Assertion implements org.ccsds.moims.mo.mal.structures.Composite
{
  /**
   * Short form for type.
   */
  public static final Integer TYPE_SHORT_FORM = Integer.valueOf(1);
  /**
   * Short form for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort AREA_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(100);
  /**
   * Version for area.
   */
  public static final org.ccsds.moims.mo.mal.structures.UOctet AREA_VERSION = new org.ccsds.moims.mo.mal.structures.UOctet((short)1);
  /**
   * Short form for service.
   */
  public static final org.ccsds.moims.mo.mal.structures.UShort SERVICE_SHORT_FORM = new org.ccsds.moims.mo.mal.structures.UShort(0);
  /**
   * Absolute short form for type.
   */
  public static final Long SHORT_FORM = Long.valueOf(28147497687842817L);
  private static final long serialVersionUID = 28147497687842817L;
  /**
   * Name of the test procedure that evaluated the assertion.
   */
  private String procedureName;
  /**
   * Message explaining what the assertion checks.
   */
  private String Info;
  /**
   * Boolean indicating whether the assertion succeeded (true) or not (false).
   */
  private Boolean Result;
  /**
   * Default constructor for Assertion.
   */
  public Assertion()
  {
  }

  /**
   * Constructor that initialises the values of the structure.
   * @param procedureName Name of the test procedure that evaluated the assertion.
   * @param Info Message explaining what the assertion checks.
   * @param Result Boolean indicating whether the assertion succeeded (true) or not (false).
   */
  public Assertion(String procedureName, String Info, Boolean Result)
  {
    this.procedureName = procedureName;
    this.Info = Info;
    this.Result = Result;
  }

  /**
   * Creates an instance of this type using the default constructor. It is a generic factory method.
   * @return A new instance of this type with default field values.
   */
  public org.ccsds.moims.mo.mal.structures.Element createElement()
  {
    return new org.ccsds.moims.mo.malprototype.structures.Assertion();
  }

  /**
   * Returns the field procedureName.
   * @return The field procedureName.
   */
  public String getProcedureName()
  {
    return procedureName;
  }

  /**
   * Sets the field procedureName.
   * @param __newValue __newValue The new value.
   */
  public void setProcedureName(String __newValue)
  {
    procedureName = __newValue;
  }

  /**
   * Returns the field Info.
   * @return The field Info.
   */
  public String getInfo()
  {
    return Info;
  }

  /**
   * Sets the field Info.
   * @param __newValue __newValue The new value.
   */
  public void setInfo(String __newValue)
  {
    Info = __newValue;
  }

  /**
   * Returns the field Result.
   * @return The field Result.
   */
  public Boolean getResult()
  {
    return Result;
  }

  /**
   * Sets the field Result.
   * @param __newValue __newValue The new value.
   */
  public void setResult(Boolean __newValue)
  {
    Result = __newValue;
  }

  /**
   * Compares this object to the specified object. The result is true if and only if the argument is not null and is the same type that contains the same value as this object.
   * @param obj obj the object to compare with.
   * @return true if the objects are the same; false otherwise.
   */
  public boolean equals(Object obj)
  {
    if (obj instanceof Assertion)
    {
      Assertion other = (Assertion) obj;
      if (procedureName == null)
      {
        if (other.procedureName != null)
        {
          return false;
        }
      }
      else
      {
        if (! procedureName.equals(other.procedureName))
        {
          return false;
        }
      }
      if (Info == null)
      {
        if (other.Info != null)
        {
          return false;
        }
      }
      else
      {
        if (! Info.equals(other.Info))
        {
          return false;
        }
      }
      if (Result == null)
      {
        if (other.Result != null)
        {
          return false;
        }
      }
      else
      {
        if (! Result.equals(other.Result))
        {
          return false;
        }
      }
      return true;
    }
    return false;
  }

  /**
   * Returns a hash code for this object.
   * @return a hash code value for this object.
   */
  public int hashCode()
  {
    int hash = 7;
    hash = 83 * hash + (procedureName != null ? procedureName.hashCode() : 0);
    hash = 83 * hash + (Info != null ? Info.hashCode() : 0);
    hash = 83 * hash + (Result != null ? Result.hashCode() : 0);
    return hash;
  }

  /**
   * Returns a String object representing this type's value.
   * @return a string representation of the value of this object.
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append('(');
    buf.append("procedureName=");
    buf.append(procedureName);
    buf.append(", Info=");
    buf.append(Info);
    buf.append(", Result=");
    buf.append(Result);
    buf.append(')');
    return buf.toString();
  }

  /**
   * Encodes the value of this object using the provided MALEncoder.
   * @param encoder encoder - the encoder to use for encoding.
   * @throws org.ccsds.moims.mo.mal.MALException if any encoding errors are detected.
   */
  public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException
  {
    encoder.encodeNullableString(procedureName);
    encoder.encodeNullableString(Info);
    encoder.encodeNullableBoolean(Result);
  }

  /**
   * Decodes the value of this object using the provided MALDecoder.
   * @param decoder decoder - the decoder to use for decoding.
   * @return Returns this object.
   * @throws org.ccsds.moims.mo.mal.MALException if any decoding errors are detected.
   */
  public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException
  {
    procedureName = decoder.decodeNullableString();
    Info = decoder.decodeNullableString();
    Result = decoder.decodeNullableBoolean();
    return this;
  }

  /**
   * Returns the absolute short form of this type.
   * @return The absolute short form of this type.
   */
  public Long getShortForm()
  {
    return SHORT_FORM;
  }

  /**
   * Returns the type short form of this type which is unique to the area/service it is defined in but not unique across all types.
   * @return The type short form of this type.
   */
  public Integer getTypeShortForm()
  {
    return TYPE_SHORT_FORM;
  }

  /**
   * Returns the area number of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getAreaNumber()
  {
    return AREA_SHORT_FORM;
  }

  /**
   * Returns the area version of this type.
   * @return The area number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet getAreaVersion()
  {
    return AREA_VERSION;
  }

  /**
   * Returns the service number of this type.
   * @return The service number of this type.
   */
  public org.ccsds.moims.mo.mal.structures.UShort getServiceNumber()
  {
    return SERVICE_SHORT_FORM;
  }

}
