/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import io.alicorn.v8.V8JavaCache;
import io.alicorn.v8.V8JavaClassInterceptor;
import io.alicorn.v8.V8JavaClassProxy;
import io.alicorn.v8.V8JavaObjectUtils;
import io.alicorn.v8.V8JavaStaticMethodProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class V8JavaAdapter {
    private static final Map<V8, V8JavaCache> runtimeToCacheMap = new HashMap<V8, V8JavaCache>();

    public static V8JavaCache getCacheForRuntime(V8 v8) {
        if (runtimeToCacheMap.containsKey(v8)) {
            return runtimeToCacheMap.get(v8);
        }
        V8JavaCache cache = new V8JavaCache();
        runtimeToCacheMap.put(v8, cache);
        return cache;
    }

    public static String injectObject(String name, Object object, V8Object rootObject) {
        V8JavaCache cache = V8JavaAdapter.getCacheForRuntime(rootObject.getRuntime());
        if (object.getClass().isArray()) {
            Object[] rawArray = (Object[])object;
            ArrayList<Object> injectedArray = new ArrayList<Object>(rawArray.length);
            for (Object obj : rawArray) {
                injectedArray.add(obj);
            }
            return V8JavaAdapter.injectObject(name, injectedArray, rootObject);
        }
        V8JavaAdapter.injectClass("".equals(object.getClass().getSimpleName()) ? object.getClass().getName().replaceAll("\\.+", "_") : object.getClass().getSimpleName(), object.getClass(), rootObject);
        if (name == null) {
            name = "TEMP" + UUID.randomUUID().toString().replaceAll("-", "");
        }
        V8JavaClassProxy proxy = cache.cachedV8JavaClasses.get(object.getClass());
        StringBuilder script = new StringBuilder();
        script.append("var ").append(name).append(" = new function() {");
        if (proxy.getInterceptor() != null) {
            script.append(proxy.getInterceptor().getConstructorScriptBody());
        }
        script.append("\n}; ").append(name).append(";");
        V8Object other = V8JavaObjectUtils.getRuntimeSarcastically((V8Value)rootObject).executeObjectScript(script.toString());
        String id = proxy.attachJavaObjectToJsObject(object, other);
        other.release();
        return id;
    }

    public static void injectClass(String name, Class<?> classy, V8JavaClassInterceptor interceptor, V8Object rootObject) {
        V8JavaClassProxy proxy;
        String v8FriendlyClassname = classy.getName().replaceAll("\\.+", "_");
        V8JavaCache cache = V8JavaAdapter.getCacheForRuntime(rootObject.getRuntime());
        if (cache.cachedV8JavaClasses.containsKey(classy)) {
            proxy = cache.cachedV8JavaClasses.get(classy);
        } else {
            proxy = new V8JavaClassProxy(classy, interceptor, cache);
            cache.cachedV8JavaClasses.put(classy, proxy);
        }
        if (!Arrays.asList(rootObject.getKeys()).contains("v8ConstructJavaClass" + v8FriendlyClassname)) {
            rootObject.registerJavaMethod((JavaCallback)proxy, "v8ConstructJavaClass" + v8FriendlyClassname);
            StringBuilder script = new StringBuilder();
            script.append("this.").append(name).append(" = function() {");
            script.append("v8ConstructJavaClass").append(v8FriendlyClassname).append(".apply(this, arguments);");
            if (proxy.getInterceptor() != null) {
                script.append(proxy.getInterceptor().getConstructorScriptBody());
            }
            script.append("\n};");
            V8JavaObjectUtils.getRuntimeSarcastically((V8Value)rootObject).executeVoidScript(script.toString());
            if (proxy.getInterceptor() == null) {
                V8Object constructorFunction = (V8Object)rootObject.get(name);
                for (V8JavaStaticMethodProxy method : proxy.getStaticMethods()) {
                    constructorFunction.registerJavaMethod((JavaCallback)method, method.getMethodName());
                }
                constructorFunction.release();
            }
        }
    }

    public static void injectClass(Class<?> classy, V8JavaClassInterceptor interceptor, V8Object object) {
        V8JavaAdapter.injectClass(classy.getSimpleName(), classy, interceptor, object);
    }

    public static void injectClass(String name, Class<?> classy, V8Object object) {
        V8JavaAdapter.injectClass(name, classy, null, object);
    }

    public static void injectClass(Class<?> classy, V8Object object) {
        V8JavaAdapter.injectClass(classy.getSimpleName(), classy, null, object);
    }
}

