/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import io.alicorn.v8.V8JavaCache;
import io.alicorn.v8.V8JavaClassInterceptor;
import io.alicorn.v8.V8JavaClassInterceptorContext;
import io.alicorn.v8.V8JavaInstanceMethodProxy;
import io.alicorn.v8.V8JavaMethodProxy;
import io.alicorn.v8.V8JavaObjectUtils;
import io.alicorn.v8.V8JavaStaticMethodProxy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class V8JavaClassProxy
implements JavaCallback {
    private final Class<?> classy;
    private final V8JavaClassInterceptor interceptor;
    private final V8JavaCache cache;
    private final Map<String, V8JavaClassInterceptorContext> interceptContexts = new HashMap<String, V8JavaClassInterceptorContext>();
    private final Map<String, V8JavaStaticMethodProxy> staticMethods = new HashMap<String, V8JavaStaticMethodProxy>();
    private final Map<String, V8JavaInstanceMethodProxy> instanceMethods = new HashMap<String, V8JavaInstanceMethodProxy>();

    List<V8JavaStaticMethodProxy> getStaticMethods() {
        return new ArrayList<V8JavaStaticMethodProxy>(this.staticMethods.values());
    }

    public V8JavaClassProxy(Class<?> classy, V8JavaClassInterceptor interceptor, V8JavaCache cache) {
        this.classy = classy;
        this.interceptor = interceptor;
        this.cache = cache;
        for (Method m : classy.getMethods()) {
            V8JavaMethodProxy methodProxy;
            if (m.getDeclaringClass().equals(Object.class)) continue;
            if (Modifier.isStatic(m.getModifiers())) {
                if (this.staticMethods.containsKey(m.getName())) {
                    this.staticMethods.get(m.getName()).addMethodSignature(m);
                    continue;
                }
                methodProxy = new V8JavaStaticMethodProxy(m.getName(), cache);
                methodProxy.addMethodSignature(m);
                this.staticMethods.put(m.getName(), (V8JavaStaticMethodProxy)methodProxy);
                continue;
            }
            if (this.instanceMethods.containsKey(m.getName())) {
                this.instanceMethods.get(m.getName()).addMethodSignature(m);
                continue;
            }
            methodProxy = new V8JavaInstanceMethodProxy(m.getName(), cache);
            methodProxy.addMethodSignature(m);
            this.instanceMethods.put(m.getName(), (V8JavaInstanceMethodProxy)methodProxy);
        }
    }

    public V8JavaClassInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void writeInjectedInterceptor(V8Object jsObject) {
        Object obj = jsObject.get("____JavaClassInterceptorContextHandleID____");
        if (obj instanceof V8Value && ((V8Value)obj).isUndefined()) {
            ((V8Value)obj).release();
            return;
        }
        String interceptorAddress = String.valueOf(obj);
        obj = jsObject.get("____JavaObjectHandleID____");
        if (obj instanceof V8Value && ((V8Value)obj).isUndefined()) {
            ((V8Value)obj).release();
            return;
        }
        String objectAddress = String.valueOf(obj);
        Object javaObject = this.cache.identifierToJavaObjectMap.get(objectAddress).get();
        V8JavaClassInterceptorContext context = this.interceptContexts.get(interceptorAddress);
        if (javaObject != null && context != null) {
            Object function = jsObject.get("onJ2V8Inject");
            if (function instanceof V8Function) {
                try {
                    this.interceptor.onInject(context, this.classy.cast(javaObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (function instanceof V8Value) {
                        ((V8Value)function).release();
                    }
                    return;
                }
                V8Array args = V8JavaObjectUtils.translateJavaArgumentsToJavascript(new Object[]{context}, V8JavaObjectUtils.getRuntimeSarcastically((V8Value)jsObject), this.cache);
                ((V8Function)function).call(jsObject, args);
                args.release();
            }
            if (function instanceof V8Value) {
                ((V8Value)function).release();
            }
        } else {
            System.err.println("omigod");
        }
    }

    public void readInjectedInterceptor(V8Object jsObject) {
        Object obj = jsObject.get("____JavaClassInterceptorContextHandleID____");
        if (obj instanceof V8Value && ((V8Value)obj).isUndefined()) {
            ((V8Value)obj).release();
            return;
        }
        String interceptorAddress = String.valueOf(obj);
        obj = jsObject.get("____JavaObjectHandleID____");
        if (obj instanceof V8Value && ((V8Value)obj).isUndefined()) {
            ((V8Value)obj).release();
            return;
        }
        String objectAddress = String.valueOf(obj);
        Object javaObject = this.cache.identifierToJavaObjectMap.get(objectAddress).get();
        V8JavaClassInterceptorContext context = this.interceptContexts.get(interceptorAddress);
        if (javaObject != null && context != null) {
            Object function = jsObject.get("onJ2V8Extract");
            if (function instanceof V8Function) {
                V8Array args = V8JavaObjectUtils.translateJavaArgumentsToJavascript(new Object[]{context}, V8JavaObjectUtils.getRuntimeSarcastically((V8Value)jsObject), this.cache);
                ((V8Function)function).call(jsObject, args);
                args.release();
                try {
                    this.interceptor.onExtract(context, this.classy.cast(javaObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (function instanceof V8Value) {
                ((V8Value)function).release();
            }
        } else {
            System.err.println("omigod");
        }
    }

    public String attachJavaObjectToJsObject(Object javaObject, V8Object jsObject) throws IllegalArgumentException {
        if (javaObject.getClass().equals(this.classy)) {
            if (this.interceptor == null) {
                for (String m : this.instanceMethods.keySet()) {
                    jsObject.registerJavaMethod(this.instanceMethods.get(m).getCallbackForInstance(javaObject), m);
                }
            } else {
                String interceptorAddress = "CICHID" + UUID.randomUUID().toString().replaceAll("-", "");
                jsObject.add("____JavaClassInterceptorContextHandleID____", interceptorAddress);
                V8JavaClassInterceptorContext context = new V8JavaClassInterceptorContext();
                this.interceptContexts.put(interceptorAddress, context);
                Object function = jsObject.get("onJ2V8Inject");
                if (function instanceof V8Function) {
                    this.interceptor.onInject(context, this.classy.cast(javaObject));
                    V8Array args = V8JavaObjectUtils.translateJavaArgumentsToJavascript(new Object[]{context}, V8JavaObjectUtils.getRuntimeSarcastically((V8Value)jsObject), this.cache);
                    ((V8Function)function).call(jsObject, args);
                    args.release();
                }
                if (function instanceof V8Value) {
                    ((V8Value)function).release();
                }
            }
            String instanceAddress = "OHID" + UUID.randomUUID().toString().replaceAll("-", "");
            jsObject.add("____JavaObjectHandleID____", instanceAddress);
            WeakReference<Object> reference = new WeakReference<Object>(javaObject);
            this.cache.identifierToJavaObjectMap.put(instanceAddress, reference);
            this.cache.v8ObjectToIdentifierMap.put(javaObject, instanceAddress);
            V8JavaObjectUtils.getRuntimeSarcastically((V8Value)jsObject).add(instanceAddress, (V8Value)jsObject);
            return instanceAddress;
        }
        throw new IllegalArgumentException(String.format("Cannot attach Java object of type [%s] using proxy for type [%s]", javaObject.getClass().getName(), this.classy.getName()));
    }

    public Object invoke(V8Object receiver, V8Array parameters) {
        Object[] coercedArguments = null;
        Constructor<?> coercedConstructor = null;
        for (Constructor<?> constructor : this.classy.getConstructors()) {
            try {
                coercedArguments = V8JavaObjectUtils.translateJavascriptArgumentsToJava(constructor.isVarArgs(), constructor.getParameterTypes(), parameters, receiver, this.cache);
                coercedConstructor = constructor;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (coercedArguments == null) {
            throw new IllegalArgumentException("No constructor exists for " + this.classy.getName() + " with specified arguments.");
        }
        try {
            Object instance = coercedConstructor.newInstance(coercedArguments);
            this.attachJavaObjectToJsObject(instance, receiver);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Constructor received invalid arguments!");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Constructor received invalid arguments!");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Constructor received invalid arguments!");
        }
        return null;
    }
}

