/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import io.alicorn.v8.V8JavaCache;
import io.alicorn.v8.V8JavaMethodProxy;
import io.alicorn.v8.V8JavaObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class V8JavaInstanceMethodProxy
extends V8JavaMethodProxy {
    private final V8JavaCache cache;

    public V8JavaInstanceMethodProxy(String name, V8JavaCache cache) {
        super(name);
        this.cache = cache;
    }

    public JavaCallback getCallbackForInstance(final Object o) {
        return new JavaCallback(){

            public Object invoke(V8Object receiver, V8Array parameters) {
                Object[] coercedArguments = null;
                Method coercedMethod = null;
                for (Method method : V8JavaInstanceMethodProxy.this.getMethodSignatures()) {
                    try {
                        coercedArguments = V8JavaObjectUtils.translateJavascriptArgumentsToJava(method.isVarArgs(), method.getParameterTypes(), parameters, receiver, V8JavaInstanceMethodProxy.this.cache);
                        coercedMethod = method;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                if (coercedArguments == null) {
                    StringBuilder errorMessage = new StringBuilder("No signature exists for ");
                    errorMessage.append(V8JavaInstanceMethodProxy.this.getMethodName());
                    errorMessage.append(" with parameters [");
                    for (int i = 0; i < parameters.length(); ++i) {
                        Object obj = parameters.get(i);
                        errorMessage.append(String.valueOf(parameters.get(i))).append(", ");
                        if (!(obj instanceof V8Value)) continue;
                        ((V8Value)obj).release();
                    }
                    errorMessage.append("].");
                    throw new IllegalArgumentException(errorMessage.toString());
                }
                try {
                    return V8JavaObjectUtils.translateJavaArgumentToJavascript(coercedMethod.invoke(o, coercedArguments), V8JavaObjectUtils.getRuntimeSarcastically((V8Value)receiver), V8JavaInstanceMethodProxy.this.cache);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Method received invalid arguments [" + e.getMessage() + "]!");
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        };
    }
}

