/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import io.alicorn.v8.V8JavaAdapter;
import io.alicorn.v8.V8JavaCache;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class V8JavaObjectUtils {
    private static final Map<Class<?>, Class<?>> BOXED_PRIMITIVE_MAP = new HashMap<Class<?>, Class<?>>(){

        @Override
        public Class<?> get(Object classy) {
            if (this.containsKey(classy)) {
                return (Class)super.get(classy);
            }
            return (Class)classy;
        }
    };
    private static final List<WeakReference<V8Value>> v8Resources;
    public static final String JAVA_OBJECT_HANDLE_ID = "____JavaObjectHandleID____";
    public static final String JAVA_CLASS_INTERCEPTOR_CONTEXT_HANDLE_ID = "____JavaClassInterceptorContextHandleID____";

    private static boolean isBasicallyPrimitive(Object object) {
        return object instanceof V8Value || object instanceof String || object instanceof Boolean || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double;
    }

    public static Object toPrimitiveArray(Object[] array, Class<?> type) {
        if (Boolean.class.equals(type)) {
            boolean[] ret = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Boolean)array[i];
            }
            return ret;
        }
        if (Byte.class.equals(type)) {
            byte[] ret = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Byte)array[i];
            }
            return ret;
        }
        if (Short.class.equals(type)) {
            short[] ret = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Short)array[i];
            }
            return ret;
        }
        if (Integer.class.equals(type)) {
            int[] ret = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Integer)array[i];
            }
            return ret;
        }
        if (Long.class.equals(type)) {
            long[] ret = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Long)array[i];
            }
            return ret;
        }
        if (Float.class.equals(type)) {
            float[] ret = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = ((Float)array[i]).floatValue();
            }
            return ret;
        }
        if (Double.class.equals(type)) {
            double[] ret = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = (Double)array[i];
            }
            return ret;
        }
        return array;
    }

    public static <T> T widenNumber(Object from, Class<T> to) {
        if (from.getClass().equals(to)) {
            return (T)from;
        }
        if (from instanceof Short) {
            if (to == Short.class || to == Short.TYPE) {
                return (T)from;
            }
            if (to == Integer.class || to == Integer.TYPE) {
                return (T)new Integer(((Short)from).shortValue());
            }
            if (to == Long.class || to == Long.TYPE) {
                return (T)new Long(((Short)from).shortValue());
            }
            if (to == Float.class || to == Float.TYPE) {
                return (T)new Float(((Short)from).shortValue());
            }
            if (to == Double.class || to == Double.TYPE) {
                return (T)new Double(((Short)from).shortValue());
            }
        } else if (from instanceof Integer) {
            if (to == Integer.class || to == Integer.TYPE) {
                return (T)from;
            }
            if (to == Long.class || to == Long.TYPE) {
                return (T)new Long(((Integer)from).intValue());
            }
            if (to == Float.class || to == Float.TYPE) {
                return (T)new Float(((Integer)from).intValue());
            }
            if (to == Double.class || to == Double.TYPE) {
                return (T)new Double(((Integer)from).intValue());
            }
        } else if (from instanceof Long) {
            if (to == Long.class || to == Long.TYPE) {
                return (T)from;
            }
            if (to == Float.class || to == Float.TYPE) {
                return (T)new Float(((Long)from).longValue());
            }
            if (to == Double.class || to == Double.TYPE) {
                return (T)new Double(((Long)from).longValue());
            }
        } else if (from instanceof Float) {
            if (to == Float.class || to == Float.TYPE) {
                return (T)from;
            }
            if (to == Double.class || to == Double.TYPE) {
                return (T)new Double(((Float)from).floatValue());
            }
        } else if (from instanceof Double && (to == Double.class || to == Double.TYPE)) {
            return (T)from;
        }
        return null;
    }

    public static final V8 getRuntimeSarcastically(V8Value value) {
        try {
            return value.getRuntime();
        }
        catch (Throwable t) {
            try {
                return (V8)value.getClass().getMethod("getRutime", new Class[0]).invoke((Object)value, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static int releaseV8Resources(V8 v8) {
        int released = 0;
        Iterator<WeakReference<V8Value>> iterator = v8Resources.iterator();
        while (iterator.hasNext()) {
            V8Value resource = (V8Value)iterator.next().get();
            if (resource != null) {
                if (V8JavaObjectUtils.getRuntimeSarcastically(resource) != v8) continue;
                resource.release();
                iterator.remove();
                ++released;
                continue;
            }
            iterator.remove();
        }
        if (released > 0) {
            V8JavaAdapter.getCacheForRuntime(v8).removeGarbageCollectedJavaObjects();
        }
        return released;
    }

    public static Object translateJavaArgumentToJavascript(Object javaArgument, V8 v8, V8JavaCache cache) {
        if (javaArgument != null) {
            if (V8JavaObjectUtils.isBasicallyPrimitive(javaArgument)) {
                return javaArgument;
            }
            String key = cache.v8ObjectToIdentifierMap.get(javaArgument);
            if (key != null) {
                V8Object object = (V8Object)v8.get(key);
                cache.cachedV8JavaClasses.get(javaArgument.getClass()).writeInjectedInterceptor(object);
                return object;
            }
            key = V8JavaAdapter.injectObject(null, javaArgument, (V8Object)v8);
            return v8.get(key);
        }
        return null;
    }

    public static V8Array translateJavaArgumentsToJavascript(Object[] javaArguments, V8 v8, V8JavaCache cache) {
        V8Array v8Args = new V8Array(v8);
        for (Object argument : javaArguments) {
            if (argument instanceof V8Value) {
                v8Args.push((V8Value)argument);
                continue;
            }
            if (argument instanceof String) {
                v8Args.push((String)argument);
                continue;
            }
            if (argument instanceof Boolean) {
                v8Args.push(((Boolean)argument).booleanValue());
                continue;
            }
            if (argument instanceof Short) {
                v8Args.push((int)((Short)argument).shortValue());
                continue;
            }
            if (argument instanceof Integer) {
                v8Args.push(((Integer)argument).intValue());
                continue;
            }
            if (argument instanceof Long) {
                v8Args.push((double)((Long)argument).longValue());
                continue;
            }
            if (argument instanceof Float) {
                v8Args.push((double)((Float)argument).floatValue());
                continue;
            }
            if (argument instanceof Double) {
                v8Args.push(((Double)argument).doubleValue());
                continue;
            }
            V8Value translatedJavaArgument = (V8Value)V8JavaObjectUtils.translateJavaArgumentToJavascript(argument, v8, cache);
            v8Args.push(translatedJavaArgument);
            translatedJavaArgument.release();
        }
        return v8Args;
    }

    public static Object translateJavascriptArgumentToJava(Class<?> javaArgumentType, Object argument, V8Object receiver, V8JavaCache cache) throws IllegalArgumentException {
        if (argument instanceof V8Value) {
            if (argument instanceof V8Function) {
                if (javaArgumentType.isInterface() && javaArgumentType.getDeclaredMethods().length == 1) {
                    V8FunctionInvocationHandler handler = new V8FunctionInvocationHandler(receiver, (V8Function)argument, cache);
                    return Proxy.newProxyInstance(javaArgumentType.getClassLoader(), new Class[]{javaArgumentType}, (InvocationHandler)handler);
                }
                throw new IllegalArgumentException("Method was passed V8Function but does not accept a functional interface.");
            }
            if (argument instanceof V8Array) {
                if (javaArgumentType.isArray()) {
                    V8Array v8Array = (V8Array)argument;
                    Class<?> originalArrayType = javaArgumentType.getComponentType();
                    Class<?> arrayType = originalArrayType;
                    if (BOXED_PRIMITIVE_MAP.containsKey(arrayType)) {
                        arrayType = BOXED_PRIMITIVE_MAP.get(arrayType);
                    }
                    Object[] array = (Object[])Array.newInstance(arrayType, v8Array.length());
                    for (int i = 0; i < array.length; ++i) {
                        Object arrayElement = v8Array.get(i);
                        try {
                            array[i] = V8JavaObjectUtils.translateJavascriptArgumentToJava(javaArgumentType.getComponentType(), arrayElement, receiver, cache);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw e;
                        }
                        finally {
                            if (arrayElement instanceof V8Value) {
                                ((V8Value)arrayElement).release();
                            }
                        }
                    }
                    if (BOXED_PRIMITIVE_MAP.containsKey(originalArrayType) && BOXED_PRIMITIVE_MAP.containsValue(arrayType)) {
                        return V8JavaObjectUtils.toPrimitiveArray(array, arrayType);
                    }
                    return array;
                }
                throw new IllegalArgumentException("Method was passed a V8Array but does not accept arrays.");
            }
            if (argument instanceof V8Object) {
                try {
                    String javaHandle = (String)((V8Object)argument).get(JAVA_OBJECT_HANDLE_ID);
                    Object javaObject = cache.identifierToJavaObjectMap.get(javaHandle).get();
                    if (javaObject != null) {
                        if (javaArgumentType.isAssignableFrom(javaObject.getClass())) {
                            cache.cachedV8JavaClasses.get(javaObject.getClass()).readInjectedInterceptor((V8Object)argument);
                            return javaObject;
                        }
                        throw new IllegalArgumentException("Argument is Java type but does not match signature for this method.");
                    }
                    cache.removeGarbageCollectedJavaObjects();
                    throw new IllegalArgumentException("Argument has invalid Java object handle or object referenced by handle has aged out.");
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Argument has invalid Java object handle or object referenced by handle has aged out.");
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Complex objects can only be passed to Java if they represent Java objects.");
                }
            }
            throw new IllegalArgumentException("Translation of JS to Java arguments is only supported for primitives, objects, arrays and functions.");
        }
        if (javaArgumentType.isAssignableFrom(argument.getClass()) || BOXED_PRIMITIVE_MAP.get(argument.getClass()).isAssignableFrom(BOXED_PRIMITIVE_MAP.get(javaArgumentType))) {
            return argument;
        }
        Object widened = V8JavaObjectUtils.widenNumber(argument, javaArgumentType);
        if (widened != null) {
            return widened;
        }
        throw new IllegalArgumentException("Primitive argument cannot be coerced to expected parameter type.");
    }

    public static Object[] translateJavascriptArgumentsToJava(boolean isVarArgs, Class<?>[] javaArgumentTypes, V8Array javascriptArguments, V8Object receiver, V8JavaCache cache) throws IllegalArgumentException {
        if (isVarArgs && javaArgumentTypes.length > 0 && javaArgumentTypes[javaArgumentTypes.length - 1].isArray() && javascriptArguments.length() >= javaArgumentTypes.length - 1) {
            Class<?> originalVarargsType = javaArgumentTypes[javaArgumentTypes.length - 1].getComponentType();
            Class<?> varargsType = originalVarargsType;
            if (BOXED_PRIMITIVE_MAP.containsKey(varargsType)) {
                varargsType = BOXED_PRIMITIVE_MAP.get(varargsType);
            }
            Object[] varargs = (Object[])Array.newInstance(varargsType, javascriptArguments.length() - javaArgumentTypes.length + 1);
            Object[] returnedArgumentValues = new Object[javaArgumentTypes.length];
            for (int i = 0; i < javascriptArguments.length(); ++i) {
                Object argument = javascriptArguments.get(i);
                try {
                    if (returnedArgumentValues.length - 1 > i) {
                        returnedArgumentValues[i] = V8JavaObjectUtils.translateJavascriptArgumentToJava(javaArgumentTypes[i], argument, receiver, cache);
                        continue;
                    }
                    varargs[i - (returnedArgumentValues.length - 1)] = V8JavaObjectUtils.translateJavascriptArgumentToJava(varargsType, argument, receiver, cache);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                finally {
                    if (argument instanceof V8Value) {
                        ((V8Value)argument).release();
                    }
                }
            }
            returnedArgumentValues[returnedArgumentValues.length - 1] = BOXED_PRIMITIVE_MAP.containsKey(originalVarargsType) && BOXED_PRIMITIVE_MAP.containsValue(varargsType) ? V8JavaObjectUtils.toPrimitiveArray(varargs, varargsType) : varargs;
            return returnedArgumentValues;
        }
        if (javaArgumentTypes.length == javascriptArguments.length()) {
            Object[] returnedArgumentValues = new Object[javaArgumentTypes.length];
            for (int i = 0; i < javascriptArguments.length(); ++i) {
                Object argument = javascriptArguments.get(i);
                try {
                    returnedArgumentValues[i] = V8JavaObjectUtils.translateJavascriptArgumentToJava(javaArgumentTypes[i], argument, receiver, cache);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                finally {
                    if (argument instanceof V8Value) {
                        ((V8Value)argument).release();
                    }
                }
            }
            return returnedArgumentValues;
        }
        throw new IllegalArgumentException("Method arguments size and passed arguments size do not match.");
    }

    static {
        BOXED_PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class);
        BOXED_PRIMITIVE_MAP.put(Short.TYPE, Short.class);
        BOXED_PRIMITIVE_MAP.put(Integer.TYPE, Integer.class);
        BOXED_PRIMITIVE_MAP.put(Long.TYPE, Long.class);
        BOXED_PRIMITIVE_MAP.put(Float.TYPE, Float.class);
        BOXED_PRIMITIVE_MAP.put(Double.TYPE, Double.class);
        v8Resources = new ArrayList<WeakReference<V8Value>>();
    }

    private static class V8FunctionInvocationHandler
    implements InvocationHandler {
        private final V8JavaCache cache;
        private final V8Object receiver;
        private final V8Function function;

        protected void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.receiver.isReleased()) {
                try {
                    this.receiver.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!this.function.isReleased()) {
                try {
                    this.function.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public V8FunctionInvocationHandler(V8Object receiver, V8Function function, V8JavaCache cache) {
            this.receiver = receiver.twin();
            this.function = function.twin();
            this.cache = cache;
            v8Resources.add(new WeakReference<V8Object>(this.receiver));
            v8Resources.add(new WeakReference<V8Function>(this.function));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            V8Array v8Args = V8JavaObjectUtils.translateJavaArgumentsToJavascript(args, V8JavaObjectUtils.getRuntimeSarcastically((V8Value)this.receiver), this.cache);
            Object obj = this.function.call(this.receiver, v8Args);
            if (!v8Args.isReleased()) {
                v8Args.release();
            }
            if (obj instanceof V8Object) {
                V8Object v8Obj = (V8Object)obj;
                if (!v8Obj.isUndefined()) {
                    Object ret = this.cache.identifierToJavaObjectMap.get(v8Obj.get(V8JavaObjectUtils.JAVA_OBJECT_HANDLE_ID).toString()).get();
                    v8Obj.release();
                    return ret;
                }
                v8Obj.release();
                return null;
            }
            return obj;
        }

        public String toString() {
            return this.function.toString();
        }
    }
}

