/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8.engine;

import com.eclipsesource.v8.V8;
import io.alicorn.v8.ConcurrentV8;
import io.alicorn.v8.ConcurrentV8Runnable;
import io.alicorn.v8.V8JavaAdapter;
import io.alicorn.v8.V8JavaObjectUtils;
import io.alicorn.v8.engine.V8ScriptingEngineFactory;
import java.io.IOException;
import java.io.Reader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class V8ScriptingEngine
extends AbstractScriptEngine
implements Invocable {
    private final ConcurrentV8 concurrentV8 = new ConcurrentV8();
    private final V8ScriptingEngineFactory factory;

    public V8ScriptingEngine(V8ScriptingEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(final String script, ScriptContext context) throws ScriptException {
        try {
            final Object[] result = new Object[1];
            this.concurrentV8.run(new ConcurrentV8Runnable(){

                @Override
                public void run(V8 v8) {
                    result[0] = v8.executeScript(script);
                }
            });
            return result[0];
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            int intValueOfChar;
            StringBuilder string = new StringBuilder();
            while ((intValueOfChar = reader.read()) != -1) {
                string.append((char)intValueOfChar);
            }
            reader.close();
            return this.eval(string.toString(), context);
        }
        catch (IOException e) {
            throw new ScriptException("Reader threw an IO exception while reading!");
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeFunction(name, args);
    }

    @Override
    public Object invokeFunction(final String name, final Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            final Object[] result = new Object[1];
            this.concurrentV8.run(new ConcurrentV8Runnable(){

                @Override
                public void run(V8 v8) {
                    result[0] = v8.executeJSFunction(name, new Object[]{V8JavaObjectUtils.translateJavaArgumentsToJavascript(args, v8, V8JavaAdapter.getCacheForRuntime(v8))});
                }
            });
            return result[0];
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

