/*
 * Decompiled with CFR 0.152.
 */
package io.alicorn.v8.engine;

import com.eclipsesource.v8.V8;
import io.alicorn.v8.engine.V8ScriptingEngine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class V8ScriptingEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "V8 Java Adapter Engine";
    private static final String ENGINE_VERSION = "0.1";
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList("js", "javascript", "es", "ecmascript"));
    private static final List<String> MIME_TYPES = Collections.unmodifiableList(Arrays.asList("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript"));
    private static final List<String> NAMES = Collections.unmodifiableList(Arrays.asList("V8", "v8", "javascript", "js", "ecmascript", "es"));
    private static final String LANGUAGE_NAME = "Javascript";

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return ENGINE_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return NAMES;
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return V8.getV8Version();
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getNames().get(0);
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder ret = new StringBuilder(obj);
        ret.append(".").append(m).append("(");
        for (int i = 0; i < args.length; ++i) {
            ret.append(args[i]);
            if (i >= args.length - 1) continue;
            ret.append(",");
        }
        ret.append(");");
        return ret.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " Does not support generated output statements.");
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String statement : statements) {
            sb.append(statement).append(";").append("\n");
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new V8ScriptingEngine(this);
    }
}

