/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.content;

import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableMetadata;
import io.annot8.components.files.utils.BufferedReaderIterator;
import io.annot8.core.exceptions.Annot8RuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CSVTable
implements Table {
    public static final String PATTERN = ",(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)";
    private final File file;
    private boolean hasHeaders;
    private TableMetadata metadata;

    public CSVTable(File file, boolean hasHeaders) {
        this.file = file;
        this.hasHeaders = hasHeaders;
        this.metadata = this.init();
    }

    public int getColumnCount() {
        return this.metadata.getColumns().size();
    }

    public int getRowCount() {
        return this.metadata.getRowCount();
    }

    public Optional<List<String>> getColumnNames() {
        List names = this.metadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        return Optional.ofNullable(names);
    }

    public Stream<Row> getRows() {
        BufferedReader bufferedReader;
        FileReader fileReader;
        try {
            fileReader = new FileReader(this.file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException e) {
            throw new Annot8RuntimeException("Failed to read file ", (Throwable)e);
        }
        BufferedReaderIterator iterator = new BufferedReaderIterator(bufferedReader, this.metadata, this.hasHeaders);
        Iterable iterable = () -> iterator;
        Stream<Row> stream = StreamSupport.stream(iterable.spliterator(), false);
        stream.onClose(() -> {
            try {
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException e) {
                throw new Annot8RuntimeException("Failed to close resources", (Throwable)e);
            }
        });
        return stream;
    }

    private TableMetadata init() {
        List<String> columnNames = null;
        int rowCount = 0;
        int columnCount = -1;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String[] data;
            String line = null;
            if (this.hasHeaders) {
                data = reader.readLine().split(PATTERN);
                columnNames = Arrays.asList(data);
            }
            while ((line = reader.readLine()) != null) {
                ++rowCount;
                if (columnCount == -1) {
                    data = line.split(PATTERN);
                    columnCount = data.length;
                    continue;
                }
                if (columnCount == line.split(PATTERN).length) continue;
                throw new Annot8RuntimeException("CSV file an irregular number of columns at line " + rowCount);
            }
        }
        catch (IOException e) {
            throw new Annot8RuntimeException("Failed to read csv file", (Throwable)e);
        }
        if (!this.hasHeaders) {
            columnNames = new ArrayList<String>(columnCount);
        }
        return new TableMetadata(this.file.getName(), "CSV", this.toColumnMetadata(columnNames), rowCount);
    }

    private List<ColumnMetadata> toColumnMetadata(List<String> columnNames) {
        return columnNames.stream().map(s -> new ColumnMetadata(s, 0L)).collect(Collectors.toList());
    }
}

