/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.TableContent;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.files.content.CSVTable;
import io.annot8.components.files.processors.CSVExtractorSettings;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.exceptions.UnsupportedContentException;
import java.io.File;
import java.util.Optional;

@ProcessesContent(value=FileContent.class)
@CreatesContent(value=TableContent.class)
public class CSVExtractor
extends AbstractComponent
implements Processor {
    public static final String CSV_TABLE = "CSV_TABLE";
    private CSVExtractorSettings settings;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        Optional optional = context.getSettings(CSVExtractorSettings.class);
        this.settings = optional.isPresent() ? (CSVExtractorSettings)optional.get() : new CSVExtractorSettings(false);
    }

    public ProcessorResponse process(Item item) throws Annot8Exception {
        item.getContents(FileContent.class).filter(c -> ((File)c.getData()).getAbsolutePath().endsWith(".csv")).forEach(c -> this.createContent(item, (File)c.getData()));
        return ProcessorResponse.ok();
    }

    private void createContent(Item item, File file) {
        try {
            item.create(TableContent.class).withName(file.getName()).withData((Object)new CSVTable(file, this.settings.hasHeaders())).save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            this.log().error("Failed to create CSV content", e);
        }
    }
}

