/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CharStreams;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.capabilities.CreatesContents;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.stream.Field;

@ProcessesContent(value=FileContent.class)
@CreatesContents(value={@CreatesContent(value=Text.class), @CreatesContent(value=InputStreamContent.class)})
public class EmlFileExtractor
extends AbstractComponent
implements Processor {
    public ProcessorResponse process(Item item) {
        item.getContents(FileContent.class).filter(f -> ((File)f.getData()).getName().endsWith(".eml")).forEach(f -> {
            try {
                Message message = Message.Builder.of((InputStream)new FileInputStream((File)f.getData())).build();
                ArrayListMultimap headers = ArrayListMultimap.create();
                message.getHeader().getFields().forEach(arg_0 -> EmlFileExtractor.lambda$process$1((ListMultimap)headers, arg_0));
                for (String key : headers.keySet()) {
                    item.getProperties().set(key, EmlFileExtractor.unlist(headers.get((Object)key)));
                }
                Body body = message.getBody();
                if (body instanceof SingleBody) {
                    this.createContentFromBody(item, body, "body", (ListMultimap<String, String>)ArrayListMultimap.create());
                } else if (body instanceof Multipart) {
                    this.processMultipart(item, (Multipart)body, "body");
                } else {
                    this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
                }
                item.removeContent(f.getName());
            }
            catch (IOException e) {
                this.log().error("Could not read file {} in content {}", new Object[]{((File)f.getData()).getName(), f.getName(), e});
            }
        });
        return ProcessorResponse.ok();
    }

    private void processMultipart(Item item, Multipart multipart, String baseName) {
        int bodyCount = 0;
        for (Entity entity : multipart.getBodyParts()) {
            ArrayListMultimap headers = ArrayListMultimap.create();
            entity.getHeader().getFields().forEach(arg_0 -> EmlFileExtractor.lambda$processMultipart$3((ListMultimap)headers, arg_0));
            if (entity.getFilename() != null) {
                this.createItemFromBody(item, entity.getBody(), entity.getFilename(), (ListMultimap<String, String>)headers);
                continue;
            }
            this.createContentFromBody(item, entity.getBody(), baseName + "-" + ++bodyCount, (ListMultimap<String, String>)headers);
        }
    }

    private void createContentFromBody(Item item, Body body, String name, ListMultimap<String, String> headers) {
        this.log().debug("Creating content {} from body", (Object)name);
        try {
            if (body instanceof TextBody) {
                TextBody textBody = (TextBody)body;
                String text = CharStreams.toString((Readable)textBody.getReader());
                Content.Builder builder = item.create(Text.class).withData((Object)text).withName(name);
                for (String key : headers.keySet()) {
                    builder.withProperty(key, EmlFileExtractor.unlist(headers.get((Object)key)));
                }
                builder.save();
            } else if (body instanceof BinaryBody) {
                BinaryBody binaryBody = (BinaryBody)body;
                Content.Builder builder = item.create(InputStreamContent.class).withData(EmlFileExtractor.createSupplier(binaryBody.getInputStream())).withName(name);
                for (String key : headers.keySet()) {
                    builder.withProperty(key, EmlFileExtractor.unlist(headers.get((Object)key)));
                }
                builder.save();
            } else if (body instanceof Multipart) {
                this.processMultipart(item, (Multipart)body, name);
            } else {
                this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
            }
        }
        catch (Exception e) {
            this.log().error("Unable to create content from body", (Throwable)e);
        }
    }

    private void createItemFromBody(Item item, Body body, String name, ListMultimap<String, String> headers) {
        this.log().debug("Creating item {} from body", (Object)name);
        try {
            if (!(body instanceof SingleBody)) {
                this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
                return;
            }
            InputStream inputStream = ((SingleBody)body).getInputStream();
            Content.Builder builder = item.create().create(InputStreamContent.class).withData(EmlFileExtractor.createSupplier(inputStream)).withName(name);
            for (String key : headers.keySet()) {
                builder.withProperty(key, EmlFileExtractor.unlist(headers.get((Object)key)));
            }
            builder.save();
        }
        catch (Exception e) {
            this.log().error("Unable to create new item from body", (Throwable)e);
        }
    }

    private static Object unlist(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }

    private static Supplier<InputStream> createSupplier(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return () -> new ByteArrayInputStream(buffer.toByteArray());
    }

    private static /* synthetic */ void lambda$processMultipart$3(ListMultimap headers, Field field) {
        headers.put((Object)field.getName(), (Object)field.getBody());
    }

    private static /* synthetic */ void lambda$process$1(ListMultimap headers, Field field) {
        headers.put((Object)field.getName(), (Object)field.getBody());
    }
}

