/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.data.Item;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;

@ProcessesContent(value=FileContent.class)
@CreatesContent(value=Text.class)
public class TxtFileExtractor
extends AbstractComponent
implements Processor {
    public ProcessorResponse process(Item item) {
        item.getContents(FileContent.class).filter(f -> ((File)f.getData()).getName().endsWith(".txt")).forEach(f -> {
            try {
                File file = (File)f.getData();
                String data = new String(Files.readAllBytes(file.toPath()), Charset.defaultCharset());
                item.create(Text.class).withName("text").withData((Object)data).save();
                item.removeContent(f.getName());
            }
            catch (Exception e) {
                this.log().warn("Unable to process file {}", (Object)((File)f.getData()).getAbsolutePath());
                this.log().debug("Unable to process file", (Throwable)e);
            }
        });
        return ProcessorResponse.ok();
    }
}

