/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.common.data.content.FileContent;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.files.sources.FileSystemSourceSettings;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.components.Source;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.data.ItemFactory;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@CreatesContent(value=FileContent.class)
public abstract class AbstractFileSystemSource
extends AbstractComponent
implements Source {
    private Set<Pattern> acceptedFilePatterns = Collections.emptySet();
    private FileSystemSourceSettings settings;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        Optional optional = context.getSettings(FileSystemSourceSettings.class);
        if (!optional.isPresent()) {
            throw new BadConfigurationException("File system settings are invalid");
        }
        this.settings = (FileSystemSourceSettings)optional.get();
        this.acceptedFilePatterns = this.settings.getAcceptedFileNamePatterns();
    }

    public FileSystemSourceSettings getSettings() {
        return this.settings;
    }

    public Set<Pattern> getAcceptedFilePatterns() {
        return this.acceptedFilePatterns;
    }

    protected boolean createItem(ItemFactory itemFactory, Path path) {
        boolean include = false;
        if (this.getAcceptedFilePatterns().isEmpty()) {
            include = true;
        } else {
            for (Pattern p : this.getAcceptedFilePatterns()) {
                Matcher m = p.matcher(path.getFileName().toString());
                if (!m.matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            Item item = itemFactory.create();
            try {
                item.getProperties().set("source", (Object)path);
                item.getProperties().set("accessedAt", (Object)Instant.now().getEpochSecond());
                item.create(FileContent.class).withName("file").withData((Object)path.toFile()).save();
                return true;
            }
            catch (Throwable t) {
                this.log().error("Unable to create item, discarding", t);
                item.discard();
            }
        }
        return false;
    }
}

