/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.exceptions.UnsupportedContentException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.TableContent;
import io.annot8.components.files.content.CSVTable;
import java.io.File;
import javax.json.bind.annotation.JsonbCreator;

@ComponentName(value="CSV Extractor")
@ComponentDescription(value="Extract CSV files into a Table content")
@SettingsClass(value=Settings.class)
public class CSVExtractor
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getHasHeaders());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withCreatesContent(TableContent.class).build();
    }

    public class Settings
    implements io.annot8.api.settings.Settings {
        private final boolean hasHeaders;

        @JsonbCreator
        public Settings(boolean hasHeaders) {
            this.hasHeaders = hasHeaders;
        }

        public boolean validate() {
            return true;
        }

        @Description(value="Does the CSV file have headers (true) or not (false)")
        public boolean getHasHeaders() {
            return this.hasHeaders;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        public static final String PROPERTY_FILE = "file";
        private final boolean hasHeaders;

        public Processor(boolean hasHeaders) {
            this.hasHeaders = hasHeaders;
        }

        public ProcessorResponse process(Item item) {
            item.getContents(FileContent.class).filter(c -> ((File)c.getData()).getAbsolutePath().endsWith(".csv")).forEach(c -> this.createContent(item, (File)c.getData()));
            return ProcessorResponse.ok();
        }

        private void createContent(Item item, File file) {
            try {
                ((Content.Builder)item.createContent(TableContent.class).withDescription(String.format("From CSV file[%s]", file.getName())).withData((Object)new CSVTable(file, this.hasHeaders)).withProperty(PROPERTY_FILE, (Object)file.getName())).save();
            }
            catch (IncompleteException | UnsupportedContentException e) {
                this.log().error("Failed to create CSV content", e);
            }
        }
    }
}

