/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.Text;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;

@ComponentName(value="Txt File Extractor")
@ComponentDescription(value="Extract text from a *.txt file and create Text content")
public class TxtFileExtractor
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withCreatesContent(Text.class).build();
    }

    public static class Processor
    extends AbstractProcessor {
        public ProcessorResponse process(Item item) {
            item.getContents(FileContent.class).filter(f -> ((File)f.getData()).getName().endsWith(".txt")).forEach(f -> {
                try {
                    File file = (File)f.getData();
                    String data = new String(Files.readAllBytes(file.toPath()), Charset.defaultCharset());
                    item.createContent(Text.class).withDescription("Text from " + f.getId()).withData((Object)data).save();
                    item.removeContent((Content)f);
                }
                catch (Exception e) {
                    this.log().warn("Unable to process file {}", (Object)((File)f.getData()).getAbsolutePath());
                    this.log().debug("Unable to process file", (Throwable)e);
                }
            });
            return ProcessorResponse.ok();
        }
    }
}

