/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CharStreams;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.common.data.content.Text;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.stream.Field;

@ComponentName(value="Eml File Extractor")
@ComponentDescription(value="Extract text and attachments from *.eml files and create new Content")
public class EmlFileExtractor
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withCreatesContent(Text.class).withCreatesContent(InputStreamContent.class).build();
    }

    public static class Processor
    extends AbstractProcessor {
        public static final String PROPERTY_PART_NAME = "name";

        public ProcessorResponse process(Item item) {
            item.getContents(FileContent.class).filter(f -> ((File)f.getData()).getName().endsWith(".eml")).forEach(f -> {
                try {
                    Message message = Message.Builder.of((InputStream)new FileInputStream((File)f.getData())).build();
                    ArrayListMultimap headers = ArrayListMultimap.create();
                    message.getHeader().getFields().forEach(arg_0 -> Processor.lambda$process$1((ListMultimap)headers, arg_0));
                    for (String key : headers.keySet()) {
                        item.getProperties().set(key, Processor.unlist(headers.get((Object)key)));
                    }
                    Body body = message.getBody();
                    if (body instanceof SingleBody) {
                        this.createContentFromBody(item, body, "body", (ListMultimap<String, String>)ArrayListMultimap.create());
                    } else if (body instanceof Multipart) {
                        this.processMultipart(item, (Multipart)body, "body");
                    } else {
                        this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
                    }
                    item.removeContent((Content)f);
                }
                catch (IOException e) {
                    this.log().error("Could not read file {} in content {}", new Object[]{((File)f.getData()).getName(), f.getId(), e});
                }
            });
            return ProcessorResponse.ok();
        }

        private void processMultipart(Item item, Multipart multipart, String baseName) {
            int bodyCount = 0;
            for (Entity entity : multipart.getBodyParts()) {
                ArrayListMultimap headers = ArrayListMultimap.create();
                entity.getHeader().getFields().forEach(arg_0 -> Processor.lambda$processMultipart$3((ListMultimap)headers, arg_0));
                if (entity.getFilename() != null) {
                    this.createItemFromBody(item, entity.getBody(), entity.getFilename(), (ListMultimap<String, String>)headers);
                    continue;
                }
                this.createContentFromBody(item, entity.getBody(), baseName + "-" + ++bodyCount, (ListMultimap<String, String>)headers);
            }
        }

        private void createContentFromBody(Item item, Body body, String name, ListMultimap<String, String> headers) {
            this.log().debug("Creating content {} from body", (Object)name);
            try {
                if (body instanceof TextBody) {
                    TextBody textBody = (TextBody)body;
                    String text = CharStreams.toString((Readable)textBody.getReader());
                    Content.Builder builder = (Content.Builder)item.createContent(Text.class).withData((Object)text).withDescription("Email " + name).withProperty(PROPERTY_PART_NAME, (Object)name);
                    for (String key : headers.keySet()) {
                        builder.withProperty(key, Processor.unlist(headers.get((Object)key)));
                    }
                    builder.save();
                } else if (body instanceof BinaryBody) {
                    BinaryBody binaryBody = (BinaryBody)body;
                    Content.Builder builder = (Content.Builder)item.createContent(InputStreamContent.class).withData(Processor.createSupplier(binaryBody.getInputStream())).withDescription("Email " + name).withProperty(PROPERTY_PART_NAME, (Object)name);
                    for (String key : headers.keySet()) {
                        builder.withProperty(key, Processor.unlist(headers.get((Object)key)));
                    }
                    builder.save();
                } else if (body instanceof Multipart) {
                    this.processMultipart(item, (Multipart)body, name);
                } else {
                    this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
                }
            }
            catch (Exception e) {
                this.log().error("Unable to create content from body", (Throwable)e);
            }
        }

        private void createItemFromBody(Item item, Body body, String name, ListMultimap<String, String> headers) {
            this.log().debug("Creating item {} from body", (Object)name);
            try {
                if (!(body instanceof SingleBody)) {
                    this.log().warn("Unexpected body type {}", (Object)body.getClass().getName());
                    return;
                }
                InputStream inputStream = ((SingleBody)body).getInputStream();
                Content.Builder builder = (Content.Builder)item.createChild().createContent(InputStreamContent.class).withData(Processor.createSupplier(inputStream)).withDescription("Email " + name).withProperty(PROPERTY_PART_NAME, (Object)name);
                for (String key : headers.keySet()) {
                    builder.withProperty(key, Processor.unlist(headers.get((Object)key)));
                }
                builder.save();
            }
            catch (Exception e) {
                this.log().error("Unable to create new item from body", (Throwable)e);
            }
        }

        private static Object unlist(List<String> list) {
            if (list.size() == 1) {
                return list.get(0);
            }
            return list;
        }

        private static Supplier<InputStream> createSupplier(InputStream inputStream) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return () -> new ByteArrayInputStream(buffer.toByteArray());
        }

        private static /* synthetic */ void lambda$processMultipart$3(ListMultimap headers, Field field) {
            headers.put((Object)field.getName(), (Object)field.getBody());
        }

        private static /* synthetic */ void lambda$process$1(ListMultimap headers, Field field) {
            headers.put((Object)field.getName(), (Object)field.getBody());
        }
    }
}

