/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.common.components.AbstractSource;
import io.annot8.common.data.content.FileContent;
import io.annot8.components.files.sources.FileSystemSourceSettings;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractFileSystemSource
extends AbstractSource {
    private Set<Pattern> acceptedFilePatterns = Collections.emptySet();
    private FileSystemSourceSettings settings;

    AbstractFileSystemSource(FileSystemSourceSettings settings) {
        this.acceptedFilePatterns = settings.getAcceptedFileNamePatterns();
        this.settings = settings;
    }

    protected FileSystemSourceSettings getSettings() {
        return this.settings;
    }

    protected Set<Pattern> getAcceptedFilePatterns() {
        return this.acceptedFilePatterns;
    }

    protected boolean createItem(ItemFactory itemFactory, Path path) {
        boolean include = false;
        if (this.getAcceptedFilePatterns().isEmpty()) {
            include = true;
        } else {
            for (Pattern p : this.getAcceptedFilePatterns()) {
                Matcher m = p.matcher(path.getFileName().toString());
                if (!m.matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            Item item = itemFactory.create();
            try {
                item.getProperties().set("source", (Object)path);
                item.getProperties().set("accessedAt", (Object)Instant.now().getEpochSecond());
                item.createContent(FileContent.class).withDescription("File " + path.toString()).withData((Object)path.toFile()).save();
                return true;
            }
            catch (Throwable t) {
                this.log().error("Unable to create item, discarding", t);
                item.discard();
            }
        }
        return false;
    }
}

