/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.utils;

import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.DefaultRow;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.TableMetadata;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class BufferedReaderIterator
implements Iterator<Row> {
    private TableMetadata metadata;
    private boolean hasHeaders;
    private BufferedReader reader;
    private int currentRow = 0;
    private List<String> columns;

    public BufferedReaderIterator(BufferedReader reader, TableMetadata metadata, boolean hasHeaders) {
        this.reader = reader;
        this.metadata = metadata;
        this.hasHeaders = hasHeaders;
        this.columns = metadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
    }

    @Override
    public boolean hasNext() {
        return this.currentRow < this.metadata.getRowCount();
    }

    @Override
    public Row next() {
        try {
            if (this.currentRow == 0 && this.hasHeaders) {
                this.reader.readLine();
            }
            String line = this.reader.readLine();
            ++this.currentRow;
            return this.toRow(line);
        }
        catch (IOException e) {
            throw new Annot8RuntimeException("Failed to read next line", (Throwable)e);
        }
    }

    private Row toRow(String line) {
        String[] data = line.split(",(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
        return new DefaultRow(this.currentRow, this.columns, Arrays.asList(data));
    }
}

