/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.ContentType;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.InputStreamContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FilterByFileContentType
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withDeletesContent(FileContent.class).withDeletesContent(InputStreamContent.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<ContentType> contentTypes = List.of();
        private boolean filterMatchingContentTypes = true;
        private boolean filterNullContentTypes = true;

        public boolean validate() {
            return this.contentTypes != null && !this.contentTypes.isEmpty();
        }

        @Description(value="The list of content types")
        public List<ContentType> getContentTypes() {
            return this.contentTypes;
        }

        public void setContentTypes(List<ContentType> contentTypes) {
            this.contentTypes = contentTypes;
        }

        @Description(value="If true, then matching content types will be removed. If false, matching content types will be kept.")
        public boolean isFilterMatchingContentTypes() {
            return this.filterMatchingContentTypes;
        }

        public void setFilterMatchingContentTypes(boolean filterMatchingContentTypes) {
            this.filterMatchingContentTypes = filterMatchingContentTypes;
        }

        @Description(value="If true, then remove content where we can't detect the content type.")
        public boolean isFilterNullContentTypes() {
            return this.filterNullContentTypes;
        }

        public void setFilterNullContentTypes(boolean filterNullContentTypes) {
            this.filterNullContentTypes = filterNullContentTypes;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;
        private final ContentInfoUtil contentInfoUtil = new ContentInfoUtil();

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            ArrayList contentToRemove = new ArrayList();
            contentToRemove.addAll(item.getContents(FileContent.class).filter(fc -> {
                try {
                    ContentInfo ci = this.contentInfoUtil.findMatch((File)fc.getData());
                    if (ci == null) {
                        return this.settings.isFilterNullContentTypes();
                    }
                    return this.settings.getContentTypes().contains(ci.getContentType()) == this.settings.isFilterMatchingContentTypes();
                }
                catch (IOException e) {
                    this.log().error("Unable to read File {} to determine content type", (Object)((File)fc.getData()).getName(), (Object)e);
                    return false;
                }
            }).collect(Collectors.toList()));
            contentToRemove.addAll(item.getContents(InputStreamContent.class).filter(isc -> {
                try {
                    ContentInfo ci = this.contentInfoUtil.findMatch((InputStream)isc.getData());
                    if (ci == null) {
                        return this.settings.isFilterNullContentTypes();
                    }
                    return this.settings.getContentTypes().contains(ci.getContentType()) == this.settings.isFilterMatchingContentTypes();
                }
                catch (IOException e) {
                    this.log().error("Unable to read InputStream {} to determine content type", (Object)isc.getId(), (Object)e);
                    return false;
                }
            }).collect(Collectors.toList()));
            if (!contentToRemove.isEmpty()) {
                this.log().debug("Removing {} Content", (Object)contentToRemove.size());
                contentToRemove.forEach(arg_0 -> ((Item)item).removeContent(arg_0));
            }
            return ProcessorResponse.ok();
        }
    }
}

