/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.Text;
import io.annot8.components.files.processors.RemoveSourceContentSettings;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

@ComponentName(value="JSON File Extractor")
@ComponentDescription(value="Extract content from *.json and *.jsonl files")
@SettingsClass(value=Settings.class)
public class JsonExtractor
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withCreatesContent(Text.class);
        if (((Settings)this.getSettings()).isRemoveSourceContent()) {
            builder = builder.withDeletesContent(FileContent.class);
        }
        return builder.build();
    }

    public static class Settings
    extends RemoveSourceContentSettings {
        private List<String> contentFields = null;
        private List<String> jsonExtension = List.of("json");
        private List<String> jsonlExtension = List.of("jsonl");

        @Override
        public boolean validate() {
            return true;
        }

        @Description(value="List of JSON fields to extract as Content, with other fields will be treated as Item properties. If null, all fields will be extracted as Content.")
        public List<String> getContentFields() {
            return this.contentFields;
        }

        public void setContentFields(List<String> contentFields) {
            this.contentFields = contentFields;
        }

        @Description(value="List of file extensions to treat as JSON files")
        public List<String> getJsonExtension() {
            return this.jsonExtension;
        }

        public void setJsonExtension(List<String> jsonExtension) {
            this.jsonExtension = jsonExtension;
        }

        @Description(value="List of file extensions to treat as JSONL (JSON Lines) files")
        public List<String> getJsonlExtension() {
            return this.jsonlExtension;
        }

        public void setJsonlExtension(List<String> jsonlExtension) {
            this.jsonlExtension = jsonlExtension;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            item.getContents(FileContent.class).forEach(f -> {
                int type = this.isSupportedExtension(((File)f.getData()).getName());
                switch (type) {
                    case 1: {
                        if (!this.processJson((FileContent)f) || !this.settings.isRemoveSourceContent()) break;
                        item.removeContent((Content)f);
                        break;
                    }
                    case 2: {
                        if (!this.processJsonL((FileContent)f) || !this.settings.isRemoveSourceContent()) break;
                        item.removeContent((Content)f);
                        break;
                    }
                }
            });
            return ProcessorResponse.ok();
        }

        private int isSupportedExtension(String filename) {
            if (this.settings.getJsonExtension() != null && this.settings.getJsonExtension().stream().anyMatch(s -> filename.toLowerCase().endsWith(s.toLowerCase()))) {
                return 1;
            }
            if (this.settings.getJsonlExtension() != null && this.settings.getJsonlExtension().stream().anyMatch(s -> filename.toLowerCase().endsWith(s.toLowerCase()))) {
                return 2;
            }
            return -1;
        }

        private boolean processJson(FileContent content) {
            try {
                String data = Files.readString(((File)content.getData()).toPath(), Charset.defaultCharset());
                this.processJson(content.getItem(), data, (File)content.getData(), -1);
            }
            catch (JsonParsingException | IOException e) {
                this.log().error("Unable to process JSON file", e);
                return false;
            }
            return true;
        }

        private boolean processJsonL(FileContent content) {
            try (FileInputStream fis = new FileInputStream((File)content.getData());
                 Scanner scanner = new Scanner(fis);){
                int line = 1;
                while (scanner.hasNextLine()) {
                    Item item = content.getItem().createChild();
                    this.processJson(item, scanner.nextLine(), (File)content.getData(), line);
                    ++line;
                }
            }
            catch (JsonParsingException | IOException e) {
                this.log().error("Unable to process JSONL file", e);
                return false;
            }
            return true;
        }

        private void processJson(Item item, String jsonString, File file, int line) {
            try (JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonString.getBytes(Charset.defaultCharset())));){
                JsonObject object = jsonReader.readObject();
                for (String key : object.keySet()) {
                    if (this.settings.getContentFields() == null || this.settings.getContentFields().contains(key)) {
                        Object o = this.getJavaObject((JsonValue)object.get((Object)key));
                        if (o == null) continue;
                        ((Content.Builder)((Content.Builder)((Content.Builder)item.createContent(Text.class).withDescription("Value of " + key + " field from " + file.getName()).withData((Object)o.toString()).withProperty("identifier", (Object)key)).withProperty("source", (Object)(file.getAbsolutePath() + (String)(line > 0 ? "#" + line : "")))).withProperty("accessedAt", (Object)LocalDateTime.now())).save();
                        continue;
                    }
                    if (((JsonValue)object.get((Object)key)).getValueType() == JsonValue.ValueType.NULL) continue;
                    item.getProperties().set(key, this.getJavaObject((JsonValue)object.get((Object)key)));
                }
            }
        }

        private Object getJavaObject(JsonValue o) {
            switch (o.getValueType()) {
                case NULL: {
                    return null;
                }
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
                case STRING: {
                    JsonString js = (JsonString)o;
                    return js.getString();
                }
                case NUMBER: {
                    JsonNumber jn = (JsonNumber)o;
                    return jn.numberValue();
                }
                case ARRAY: {
                    JsonArray ja = (JsonArray)o;
                    ArrayList l = new ArrayList(ja.size());
                    ja.forEach(v -> l.add(this.getJavaObject((JsonValue)v)));
                    return l;
                }
                case OBJECT: {
                    JsonObject jo = (JsonObject)o;
                    HashMap m = new HashMap(jo.size());
                    jo.forEach((k, v) -> m.put(k, this.getJavaObject((JsonValue)v)));
                    return m;
                }
            }
            return null;
        }
    }
}

