/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ComponentName(value="Move Source File")
@ComponentDescription(value="Move (or copy) the source file to a different directory")
@SettingsClass(value=Settings.class)
public class MoveSourceFile
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path rootOutputFolder = Path.of(".", new String[0]);
        private List<Path> basePaths = Collections.emptyList();
        private boolean copyOriginalFile = false;
        private boolean replaceExisting = false;
        private boolean flatten = false;
        private boolean updateSource = false;

        public boolean validate() {
            return this.rootOutputFolder != null && this.basePaths != null;
        }

        @Description(value="The root folder in which to save files", defaultValue=".")
        public Path getRootOutputFolder() {
            return this.rootOutputFolder;
        }

        public void setRootOutputFolder(Path rootOutputFolder) {
            this.rootOutputFolder = rootOutputFolder;
        }

        @Description(value="If the source path of any Item begins with any of these paths, then it will be truncated")
        public List<Path> getBasePaths() {
            return this.basePaths;
        }

        public void setBasePaths(List<Path> basePaths) {
            this.basePaths = basePaths;
        }

        @Description(value="If true, then the source file is copied instead of moved", defaultValue="false")
        public boolean isCopyOriginalFile() {
            return this.copyOriginalFile;
        }

        public void setCopyOriginalFile(boolean copyOriginalFile) {
            this.copyOriginalFile = copyOriginalFile;
        }

        @Description(value="If true, then any existing files will be replaced. If false, then an error will be thrown if the target file already exists.", defaultValue="false")
        public boolean isReplaceExisting() {
            return this.replaceExisting;
        }

        public void setReplaceExisting(boolean replaceExisting) {
            this.replaceExisting = replaceExisting;
        }

        @Description(value="If true, then all files are moved into the same top level folder and the base path is ignored", defaultValue="false")
        public boolean isFlatten() {
            return this.flatten;
        }

        public void setFlatten(boolean flatten) {
            this.flatten = flatten;
        }

        @Description(value="If true, then the source property of the Item is updated following a successful move", defaultValue="false")
        public boolean isUpdateSource() {
            return this.updateSource;
        }

        public void setUpdateSource(boolean updateSource) {
            this.updateSource = updateSource;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            Optional<Path> source = Processor.getItemSource(item);
            if (source.isEmpty()) {
                this.log().debug("Could not find or parse source for item {}", (Object)item.getId());
                return ProcessorResponse.ok();
            }
            Path target = Processor.getTargetPath(source.get(), this.settings.getRootOutputFolder(), this.settings.getBasePaths(), this.settings.isFlatten());
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log().error("Unable to create directory for item {}", (Object)item.getId(), (Object)e);
                return ProcessorResponse.itemError((Exception[])new Exception[]{e});
            }
            ArrayList<StandardCopyOption> copyOptions = new ArrayList<StandardCopyOption>();
            if (this.settings.isCopyOriginalFile()) {
                copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
            }
            if (this.settings.isReplaceExisting()) {
                copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
            }
            if (this.settings.isCopyOriginalFile()) {
                try {
                    Files.copy(source.get(), target, copyOptions.toArray(new CopyOption[0]));
                }
                catch (IOException e) {
                    this.log().error("Unable to copy source file {} to {} for item {}", new Object[]{source.get(), target, item.getId(), e});
                    return ProcessorResponse.itemError((Exception[])new Exception[]{e});
                }
                this.log().info("Source file {} copied to {} for item {}", new Object[]{source.get(), target, item.getId()});
            } else {
                try {
                    Files.move(source.get(), target, copyOptions.toArray(new CopyOption[0]));
                }
                catch (IOException e) {
                    this.log().error("Unable to move source file {} to {} for item {}", new Object[]{source.get(), target, item.getId(), e});
                    return ProcessorResponse.itemError((Exception[])new Exception[]{e});
                }
                this.log().info("Source file {} moved to {} for item {}", new Object[]{source.get(), target, item.getId()});
            }
            if (this.settings.isUpdateSource()) {
                item.getProperties().set("source", (Object)target);
            }
            return ProcessorResponse.ok();
        }

        protected static Optional<Path> getItemSource(Item item) {
            Path p;
            Optional o = item.getProperties().get("source");
            if (o.isEmpty()) {
                return Optional.empty();
            }
            Object source = o.get();
            if (source instanceof Path) {
                p = (Path)source;
            } else if (source instanceof File) {
                p = ((File)source).toPath();
            } else if (source instanceof String) {
                p = Path.of((String)source, new String[0]);
            } else if (source instanceof URI) {
                p = Path.of((URI)source);
            } else {
                return Optional.empty();
            }
            return Optional.of(p);
        }

        protected static Path getTargetPath(Path source, Path rootOutputFolder, List<Path> baseSourceFolders, boolean flatten) {
            Path cleanSource = flatten ? source.getFileName() : baseSourceFolders.stream().filter(source::startsWith).findFirst().map(path -> path.relativize(source)).orElse(source);
            return Path.of(rootOutputFolder.toString(), cleanSource.toString());
        }
    }
}

