/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sinks;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

@ComponentName(value="Annotations to Text File")
@ComponentDescription(value="Appends annotation values to a text file")
@SettingsClass(value=Settings.class)
public class AnnotationsToTextFile
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesAnnotations("*", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path outputFile = Path.of("values.txt", new String[0]);
        private boolean deleteOnStart = false;
        private boolean deduplicate = true;
        private List<String> annotationTypes = List.of();

        public boolean validate() {
            return this.outputFile != null && this.annotationTypes != null;
        }

        @Description(value="The file to output annotation values into")
        public Path getOutputFile() {
            return this.outputFile;
        }

        public void setOutputFile(Path outputFile) {
            this.outputFile = outputFile;
        }

        @Description(value="If true, the output file will be deleted when the pipeline first runs")
        public boolean isDeleteOnStart() {
            return this.deleteOnStart;
        }

        public void setDeleteOnStart(boolean deleteOnStart) {
            this.deleteOnStart = deleteOnStart;
        }

        @Description(value="If true, then only unique values will be added to the file")
        public boolean isDeduplicate() {
            return this.deduplicate;
        }

        public void setDeduplicate(boolean deduplicate) {
            this.deduplicate = deduplicate;
        }

        @Description(value="A list of annotation types to process, or leave empty to process all annotations")
        public List<String> getAnnotationTypes() {
            return this.annotationTypes;
        }

        public void setAnnotationTypes(List<String> annotationTypes) {
            this.annotationTypes = annotationTypes;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;
        private final Set<String> prev = new HashSet<String>();

        public Processor(Settings settings) {
            this.settings = settings;
            if (settings.isDeleteOnStart()) {
                try {
                    Files.deleteIfExists(settings.getOutputFile());
                }
                catch (IOException e) {
                    this.log().warn("Unable to delete file {}", (Object)settings.getOutputFile(), (Object)e);
                }
            } else if (settings.isDeduplicate()) {
                try {
                    Files.lines(settings.getOutputFile()).map(String::strip).distinct().forEach(this.prev::add);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    this.log().warn("Could not read file {} to identify initial set of terms", (Object)settings.getOutputFile(), (Object)e);
                }
            }
            try {
                Path parent = settings.getOutputFile().getParent();
                if (parent != null) {
                    Files.createDirectories(settings.getOutputFile().getParent(), new FileAttribute[0]);
                }
                Files.createFile(settings.getOutputFile(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException parent) {
            }
            catch (IOException ioe) {
                this.log().error("Unable to create output file {}", (Object)settings.getOutputFile(), (Object)ioe);
            }
        }

        public ProcessorResponse process(Item item) {
            ArrayList values = new ArrayList();
            item.getContents(Text.class).forEach(t -> {
                Stream<Annotation> annotations = t.getAnnotations().getByBounds(SpanBounds.class);
                if (this.settings.getAnnotationTypes() != null && !this.settings.getAnnotationTypes().isEmpty()) {
                    annotations = annotations.filter(a -> this.settings.getAnnotationTypes().contains(a.getType()));
                }
                Stream<String> vals = annotations.map(a -> a.getProperties().get("value", String.class).orElse(((SpanBounds)a.getBounds(SpanBounds.class).orElseThrow()).getData((Content)t).orElse("")).strip()).filter(s -> !s.isBlank());
                if (this.settings.isDeduplicate()) {
                    vals = vals.distinct().filter(this.prev::add);
                }
                vals.forEach(values::add);
            });
            if (!values.isEmpty()) {
                try {
                    Files.write(this.settings.getOutputFile(), values, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    this.log().error("Unable to write annotation values to file {}", (Object)this.settings.getOutputFile(), (Object)e);
                    return ProcessorResponse.processingError((Exception[])new Exception[]{e});
                }
            }
            return ProcessorResponse.ok();
        }
    }
}

