/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sinks;

import com.google.common.base.Strings;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.CellBounds;
import io.annot8.common.data.bounds.ContentBounds;
import io.annot8.common.data.bounds.MultiCellBounds;
import io.annot8.common.data.bounds.NoBounds;
import io.annot8.common.data.bounds.PositionBounds;
import io.annot8.common.data.bounds.RectangleBounds;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.Image;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import io.annot8.common.data.content.Text;
import io.annot8.common.data.content.UriContent;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;

@ComponentName(value="File Sink")
@ComponentDescription(value="Outputs extracted content and metadata as files within a nested folder structure")
@SettingsClass(value=Settings.class)
public class FileSink
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Content.class).withProcessesAnnotations("*", Bounds.class).withProcessesGroups("*").build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path rootOutputFolder = Path.of(".", new String[0]);
        private String propertiesFilename = "properties.json";
        private String contentFilename = "content";
        private ImageType imageType = ImageType.JPG;
        private String annotationsFilename = "annotations.json";
        private String groupsFilename = "groups.json";
        private List<Path> basePaths = Collections.emptyList();
        private boolean copyOriginalFile = false;
        private String descriptionFilename = "description.txt";
        private boolean nestFolders = false;

        public boolean validate() {
            return this.rootOutputFolder != null && this.imageType != null && this.basePaths != null;
        }

        @Description(value="The root folder in which to save files", defaultValue=".")
        public Path getRootOutputFolder() {
            return this.rootOutputFolder;
        }

        public void setRootOutputFolder(Path rootOutputFolder) {
            this.rootOutputFolder = rootOutputFolder;
        }

        @Description(value="The file name for files containing Item and Content properties", defaultValue="properties.json")
        public String getPropertiesFilename() {
            return this.propertiesFilename;
        }

        public void setPropertiesFilename(String propertiesFilename) {
            this.propertiesFilename = propertiesFilename;
        }

        @Description(value="The file name for extracted Content - a suitable extension will be added", defaultValue="content")
        public String getContentFilename() {
            return this.contentFilename;
        }

        public void setContentFilename(String contentFilename) {
            this.contentFilename = contentFilename;
        }

        @Description(value="The format that image Content should be saved in", defaultValue="JPG")
        public ImageType getImageType() {
            return this.imageType;
        }

        public void setImageType(ImageType imageType) {
            this.imageType = imageType;
        }

        @Description(value="The file name for files containing Content annotations", defaultValue="annotations.json")
        public String getAnnotationsFilename() {
            return this.annotationsFilename;
        }

        public void setAnnotationsFilename(String annotationsFilename) {
            this.annotationsFilename = annotationsFilename;
        }

        @Description(value="The file name for files containing Item groups", defaultValue="groups.json")
        public String getGroupsFilename() {
            return this.groupsFilename;
        }

        public void setGroupsFilename(String groupsFilename) {
            this.groupsFilename = groupsFilename;
        }

        @Description(value="If the source path of any Item begins with any of these paths, then it will be truncated")
        public List<Path> getBasePaths() {
            return this.basePaths;
        }

        public void setBasePaths(List<Path> basePaths) {
            this.basePaths = basePaths;
        }

        @Description(value="If true, and the source file for an item can be identified, then it is copied into the Item folder", defaultValue="false")
        public boolean isCopyOriginalFile() {
            return this.copyOriginalFile;
        }

        public void setCopyOriginalFile(boolean copyOriginalFile) {
            this.copyOriginalFile = copyOriginalFile;
        }

        @Description(value="The file name for the description of Content", defaultValue="description.txt")
        public String getDescriptionFilename() {
            return this.descriptionFilename;
        }

        public void setDescriptionFilename(String descriptionFilename) {
            this.descriptionFilename = descriptionFilename;
        }

        @Description(value="If true, then Content folders will be nested inside their parent folders where the parent is known", defaultValue="false")
        public boolean isNestFolders() {
            return this.nestFolders;
        }

        public void setNestFolders(boolean nestFolders) {
            this.nestFolders = nestFolders;
        }

        public static enum ImageType {
            JPG,
            PNG;

        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            Optional source;
            File itemFolder;
            try {
                itemFolder = Files.createDirectories(Processor.getItemPath(item, this.settings.getRootOutputFolder(), this.settings.getBasePaths()), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                this.log().error("Unable to create directory for item {}", (Object)item.getId(), (Object)e);
                return ProcessorResponse.itemError((Exception[])new Exception[]{e});
            }
            if (this.settings.isCopyOriginalFile() && (source = item.getProperties().get("source")).isPresent()) {
                try {
                    Processor.copyOriginalFile(source.get(), itemFolder.toPath());
                }
                catch (IOException e) {
                    this.log().error("Unable to copy original file for item {}", (Object)item.getId(), (Object)e);
                }
            }
            if (!Strings.isNullOrEmpty((String)this.settings.getPropertiesFilename())) {
                try {
                    Processor.writeJson(Processor.objectToJson(item.getProperties().getAll()), new File(itemFolder, this.settings.getPropertiesFilename()));
                }
                catch (IOException e) {
                    this.log().error("Unable to write properties file for item {}", (Object)item.getId(), (Object)e);
                }
            }
            if (!Strings.isNullOrEmpty((String)this.settings.getGroupsFilename())) {
                try {
                    Processor.writeJson((JsonValue)Processor.groupsToJson(item.getGroups().getAll()), new File(itemFolder, this.settings.getGroupsFilename()));
                }
                catch (IOException e) {
                    this.log().error("Unable to write groups file for item {}", (Object)item.getId(), (Object)e);
                }
            }
            HashMap parents = new HashMap();
            if (this.settings.isNestFolders()) {
                item.getContents().forEach(c -> c.getProperties().get("parent", String.class).ifPresent(s -> parents.put(c.getId(), s)));
            }
            item.getContents().forEach(content -> {
                File contentFolder;
                ArrayList<String> parentIds = new ArrayList<String>();
                String id = content.getId();
                while (id != null) {
                    parentIds.add(id);
                    id = (String)parents.get(id);
                }
                Collections.reverse(parentIds);
                try {
                    contentFolder = Files.createDirectories(itemFolder.toPath().resolve(Path.of((String)parentIds.remove(0), parentIds.toArray(new String[0]))), new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    this.log().error("Unable to create directory for content {}", (Object)content.getId(), (Object)e);
                    return;
                }
                if (!Strings.isNullOrEmpty((String)this.settings.getContentFilename())) {
                    try {
                        Processor.writeContent(content, contentFolder, this.settings);
                    }
                    catch (IOException e) {
                        this.log().error("Unable to write content to disk", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        this.log().warn("Unsupported content", (Throwable)e);
                    }
                }
                if (!Strings.isNullOrEmpty((String)this.settings.getPropertiesFilename())) {
                    try {
                        Processor.writeJson(Processor.objectToJson(content.getProperties().getAll()), new File(contentFolder, this.settings.getPropertiesFilename()));
                    }
                    catch (IOException e) {
                        this.log().error("Unable to write properties file for content {}", (Object)content.getId(), (Object)e);
                    }
                }
                if (!Strings.isNullOrEmpty((String)this.settings.getAnnotationsFilename())) {
                    try {
                        Processor.writeJson((JsonValue)Processor.annotationsToJson(content.getAnnotations().getAll()), new File(contentFolder, this.settings.getAnnotationsFilename()));
                    }
                    catch (IOException e) {
                        this.log().error("Unable to write annotations file for content {}", (Object)content.getId(), (Object)e);
                    }
                }
                if (!Strings.isNullOrEmpty((String)this.settings.getDescriptionFilename()) && !Strings.isNullOrEmpty((String)content.getDescription())) {
                    try {
                        Files.writeString(new File(contentFolder, this.settings.getDescriptionFilename()).toPath(), (CharSequence)content.getDescription(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        this.log().error("Unable to write description file for content {}", (Object)content.getId(), (Object)e);
                    }
                }
            });
            return ProcessorResponse.ok();
        }

        protected static Path copyOriginalFile(Object source, Path targetDirectory) throws IOException {
            Path p;
            if (source instanceof Path) {
                p = (Path)source;
            } else if (source instanceof File) {
                p = ((File)source).toPath();
            } else if (source instanceof String) {
                p = Path.of((String)source, new String[0]);
            } else if (source instanceof URI) {
                p = Path.of((URI)source);
            } else {
                return null;
            }
            return Files.copy(p, targetDirectory.resolve(p.getFileName()), StandardCopyOption.COPY_ATTRIBUTES);
        }

        protected static Path getItemPath(Item item, Path rootOutputFolder, List<Path> baseSourceFolders) {
            Optional o = item.getProperties().get("source");
            if (o.isEmpty()) {
                return rootOutputFolder.resolve(item.getId());
            }
            Path source = Path.of(o.get().toString(), new String[0]);
            Path cleanSource = baseSourceFolders.stream().filter(source::startsWith).findFirst().map(path -> path.relativize(source)).orElse(source);
            return Path.of(rootOutputFolder.toString(), cleanSource.toString());
        }

        protected static void writeJson(JsonValue json, File outputFile) throws IOException {
            if (JsonValue.NULL.equals(json) || JsonValue.EMPTY_JSON_ARRAY.equals(json) || JsonValue.EMPTY_JSON_OBJECT.equals(json)) {
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(outputFile);
                 JsonWriter writer = Json.createWriter((OutputStream)fos);){
                writer.write(json);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static File writeContent(Content<?> content, File contentFolder, Settings settings) throws IOException, IllegalArgumentException {
            File f;
            if (content instanceof Text) {
                f = new File(contentFolder, settings.getContentFilename() + ".txt");
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
                    bw.write((String)((Text)content).getData());
                    return f;
                }
            }
            if (content instanceof FileContent) {
                Path source = ((File)((FileContent)content).getData()).toPath();
                f = new File(contentFolder, settings.getContentFilename() + "." + com.google.common.io.Files.getFileExtension((String)source.toString()));
                Files.copy(source, f.toPath(), new CopyOption[0]);
                return f;
            }
            if (content instanceof InputStreamContent) {
                f = new File(contentFolder, settings.getContentFilename());
                try (FileOutputStream fos = new FileOutputStream(f);){
                    ((InputStream)((InputStreamContent)content).getData()).transferTo(fos);
                    return f;
                }
            }
            if (content instanceof Image) {
                String extension;
                switch (settings.getImageType()) {
                    case JPG: {
                        extension = ".jpg";
                        break;
                    }
                    case PNG: {
                        extension = ".png";
                        break;
                    }
                    default: {
                        extension = "";
                    }
                }
                f = new File(contentFolder, settings.getContentFilename() + extension);
                try (FileOutputStream fos = new FileOutputStream(f);){
                    switch (settings.getImageType()) {
                        case JPG: {
                            ((Image)content).saveAsJpg((OutputStream)fos);
                            return f;
                        }
                        case PNG: {
                            ((Image)content).saveAsPng((OutputStream)fos);
                            return f;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type " + settings.getImageType() + " is not supported");
                        }
                    }
                }
            }
            if (content instanceof UriContent) {
                f = new File(contentFolder, settings.getContentFilename() + ".url");
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
                    bw.write("[InternetShortcut]\nURL=" + ((URI)((UriContent)content).getData()).toString());
                    return f;
                }
            }
            if (!(content instanceof TableContent)) throw new IllegalArgumentException("Content type " + content.getContentClass().getName() + " is not supported");
            f = new File(contentFolder, settings.getContentFilename() + ".csv");
            Table tbl = (Table)((TableContent)content).getData();
            StringJoiner sj = new StringJoiner("\n");
            tbl.getColumnNames().ifPresent(names -> {
                StringJoiner rowSj = new StringJoiner(",");
                names.forEach(s -> rowSj.add(StringEscapeUtils.escapeCsv((String)s)));
                sj.add(rowSj.toString());
            });
            tbl.getRows().forEach(row -> {
                StringJoiner rowSj = new StringJoiner(",");
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    rowSj.add(StringEscapeUtils.escapeCsv((String)row.getValueAt(i).orElse("").toString()));
                }
                sj.add(rowSj.toString());
            });
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
                bw.write(sj.toString());
                return f;
            }
        }

        protected static JsonValue objectToJson(Object object) {
            if (object == null) {
                return JsonValue.NULL;
            }
            if (object instanceof JsonValue) {
                return (JsonValue)object;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? JsonValue.TRUE : JsonValue.FALSE;
            }
            if (object instanceof Integer) {
                return Json.createValue((int)((Integer)object));
            }
            if (object instanceof Long) {
                return Json.createValue((long)((Long)object));
            }
            if (object instanceof Double) {
                return Json.createValue((double)((Double)object));
            }
            if (object instanceof BigInteger) {
                return Json.createValue((BigInteger)((BigInteger)object));
            }
            if (object instanceof BigDecimal) {
                return Json.createValue((BigDecimal)((BigDecimal)object));
            }
            if (object instanceof Collection) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                ((Collection)object).forEach(o -> arrayBuilder.add(Processor.objectToJson(o)));
                return arrayBuilder.build();
            }
            if (object instanceof Map) {
                JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
                ((Map)object).forEach((k, v) -> objectBuilder.add(k.toString(), Processor.objectToJson(v)));
                return objectBuilder.build();
            }
            return Json.createValue((String)object.toString());
        }

        protected static JsonArray annotationsToJson(Stream<Annotation> annotations) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            annotations.forEach(a -> arrayBuilder.add((JsonValue)Processor.annotationToJson(a)));
            return arrayBuilder.build();
        }

        protected static JsonObject annotationToJson(Annotation annotation) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("id", annotation.getId());
            objectBuilder.add("contentId", annotation.getContentId());
            objectBuilder.add("type", annotation.getType());
            objectBuilder.add("properties", Processor.objectToJson(annotation.getProperties().getAll()));
            try {
                objectBuilder.add("bounds", Processor.boundsToJson(annotation.getBounds()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return objectBuilder.build();
        }

        protected static JsonValue boundsToJson(Bounds bounds) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            if (bounds instanceof SpanBounds) {
                builder.add("begin", ((SpanBounds)bounds).getBegin());
                builder.add("end", ((SpanBounds)bounds).getEnd());
            } else if (bounds instanceof PositionBounds) {
                builder.add("position", ((PositionBounds)bounds).getPosition());
            } else if (bounds instanceof RectangleBounds) {
                builder.add("top", ((RectangleBounds)bounds).getTop());
                builder.add("bottom", ((RectangleBounds)bounds).getBottom());
                builder.add("left", ((RectangleBounds)bounds).getLeft());
                builder.add("right", ((RectangleBounds)bounds).getRight());
            } else if (bounds instanceof CellBounds) {
                builder.add("row", ((CellBounds)bounds).getRow());
                builder.add("column", ((CellBounds)bounds).getColumn());
            } else if (bounds instanceof MultiCellBounds) {
                builder.add("row", ((MultiCellBounds)bounds).getRow());
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (int col : ((MultiCellBounds)bounds).getCells()) {
                    arrayBuilder.add(col);
                }
                builder.add("columns", arrayBuilder);
            } else {
                if (bounds instanceof NoBounds || bounds instanceof ContentBounds) {
                    return JsonValue.EMPTY_JSON_OBJECT;
                }
                throw new IllegalArgumentException("Bounds type " + bounds.getClass() + " is not supported");
            }
            return builder.build();
        }

        protected static JsonArray groupsToJson(Stream<Group> groups) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            groups.forEach(g -> arrayBuilder.add((JsonValue)Processor.groupToJson(g)));
            return arrayBuilder.build();
        }

        protected static JsonObject groupToJson(Group group) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("id", group.getId());
            objectBuilder.add("type", group.getType());
            objectBuilder.add("properties", Processor.objectToJson(group.getProperties().getAll()));
            JsonObjectBuilder annotationsObjectBuilder = Json.createObjectBuilder();
            group.getAnnotations().forEach((role, annotations) -> annotationsObjectBuilder.add(role, (JsonValue)Processor.annotationsToJson(annotations)));
            objectBuilder.add("annotations", annotationsObjectBuilder);
            return objectBuilder.build();
        }
    }
}

