/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sinks;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@ComponentName(value="Text to File")
@ComponentDescription(value="Save Text Content to a file on disk")
@SettingsClass(value=Settings.class)
public class TextToFile
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path outputFolder = Path.of("./text", new String[0]);

        public boolean validate() {
            return this.outputFolder != null;
        }

        @Description(value="The folder to save text files into")
        public Path getOutputFolder() {
            return this.outputFolder;
        }

        public void setOutputFolder(Path outputFolder) {
            this.outputFolder = outputFolder;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        protected void process(Text content) {
            Path p = this.settings.getOutputFolder().resolve(content.getItem().getId()).resolve(content.getId() + ".txt");
            try {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log().error("Could not create directory {}", (Object)p.getParent());
                throw new ProcessingException("Could not create directory", (Throwable)e);
            }
            try {
                Files.writeString(p, (CharSequence)content.getData(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.log().error("Unable to write text file for {}", (Object)content.getId(), (Object)e);
                throw new ProcessingException("Unable to write text file", (Throwable)e);
            }
        }
    }
}

