/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractSource;
import io.annot8.common.components.AbstractSourceDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;

@ComponentName(value="Simple File System Source")
@ComponentDescription(value="Take a list of folders and processes files in them, without watching for changes or new files")
@SettingsClass(value=Settings.class)
public class SimpleFileSystemSource
extends AbstractSourceDescriptor<Source, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesContent(FileContent.class).build();
    }

    protected Source createComponent(Context context, Settings settings) {
        return new Source(settings);
    }

    public static enum FileOrder {
        CREATED_DATE_EARLIEST_TO_LATEST,
        CREATED_DATE_LATEST_TO_EARLIEST,
        MODIFIED_DATE_EARLIEST_TO_LATEST,
        MODIFIED_DATE_LATEST_TO_EARLIEST,
        NAME_A_TO_Z,
        NAME_Z_TO_A,
        SIZE_LARGE_TO_SMALL,
        SIZE_SMALL_TO_LARGE;

    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<Path> paths = new ArrayList<Path>();
        private List<String> extensions = new ArrayList<String>();
        private boolean recursive = true;
        private FileOrder fileOrder = FileOrder.NAME_A_TO_Z;

        public boolean validate() {
            return this.extensions != null && this.paths != null && !this.paths.isEmpty();
        }

        @Description(value="List of paths to process")
        public List<Path> getPaths() {
            return this.paths;
        }

        public void setPaths(List<Path> paths) {
            this.paths = paths;
        }

        @Description(value="List of file extensions to accept (accepts all files if no extensions are given)")
        public List<String> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<String> extensions) {
            this.extensions = extensions.stream().map(String::toLowerCase).collect(Collectors.toList());
        }

        @Description(value="Should we process paths recursively?")
        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        @Description(value="The order in which files will be processed")
        public FileOrder getFileOrder() {
            return this.fileOrder;
        }

        public void setFileOrder(FileOrder fileOrder) {
            this.fileOrder = fileOrder;
        }
    }

    public static class Source
    extends AbstractSource {
        private final Queue<Path> files = new LinkedList<Path>();

        public Source(Settings settings) {
            if (settings.isRecursive()) {
                settings.getPaths().forEach(p -> {
                    try {
                        Files.walk(p, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> Source.acceptExtension(settings.getExtensions(), path)).sorted(Source.sortPaths(settings.getFileOrder())).forEach(this.files::add);
                    }
                    catch (Exception e) {
                        this.log().error("Unable to read files recursively in path {}", p, (Object)e);
                    }
                });
            } else {
                settings.getPaths().forEach(p -> {
                    try {
                        Files.list(p).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> Source.acceptExtension(settings.getExtensions(), path)).sorted(Source.sortPaths(settings.getFileOrder())).forEach(this.files::add);
                    }
                    catch (Exception e) {
                        this.log().error("Unable to read files in path {}", p, (Object)e);
                    }
                });
            }
            this.log().info("{} files to be processed", (Object)this.files.size());
        }

        private static boolean acceptExtension(List<String> extensions, Path p) {
            if (extensions.isEmpty()) {
                return true;
            }
            return extensions.contains(com.google.common.io.Files.getFileExtension((String)p.toString()).toLowerCase());
        }

        private static Comparator<Path> sortPaths(FileOrder fileOrder) {
            switch (fileOrder) {
                case CREATED_DATE_EARLIEST_TO_LATEST: {
                    return (p1, p2) -> {
                        try {
                            BasicFileAttributes bfa1 = Files.readAttributes(p1, BasicFileAttributes.class, new LinkOption[0]);
                            BasicFileAttributes bfa2 = Files.readAttributes(p2, BasicFileAttributes.class, new LinkOption[0]);
                            return bfa1.creationTime().compareTo(bfa2.creationTime());
                        }
                        catch (IOException ioe) {
                            return 0;
                        }
                    };
                }
                case CREATED_DATE_LATEST_TO_EARLIEST: {
                    return (p1, p2) -> {
                        try {
                            BasicFileAttributes bfa1 = Files.readAttributes(p1, BasicFileAttributes.class, new LinkOption[0]);
                            BasicFileAttributes bfa2 = Files.readAttributes(p2, BasicFileAttributes.class, new LinkOption[0]);
                            return bfa2.creationTime().compareTo(bfa1.creationTime());
                        }
                        catch (IOException ioe) {
                            return 0;
                        }
                    };
                }
                case MODIFIED_DATE_EARLIEST_TO_LATEST: {
                    return (p1, p2) -> {
                        try {
                            BasicFileAttributes bfa1 = Files.readAttributes(p1, BasicFileAttributes.class, new LinkOption[0]);
                            BasicFileAttributes bfa2 = Files.readAttributes(p2, BasicFileAttributes.class, new LinkOption[0]);
                            return bfa1.lastModifiedTime().compareTo(bfa2.lastModifiedTime());
                        }
                        catch (IOException ioe) {
                            return 0;
                        }
                    };
                }
                case MODIFIED_DATE_LATEST_TO_EARLIEST: {
                    return (p1, p2) -> {
                        try {
                            BasicFileAttributes bfa1 = Files.readAttributes(p1, BasicFileAttributes.class, new LinkOption[0]);
                            BasicFileAttributes bfa2 = Files.readAttributes(p2, BasicFileAttributes.class, new LinkOption[0]);
                            return bfa2.lastModifiedTime().compareTo(bfa1.lastModifiedTime());
                        }
                        catch (IOException ioe) {
                            return 0;
                        }
                    };
                }
                case NAME_A_TO_Z: {
                    return Comparator.comparing(p -> p.getFileName().toString());
                }
                case NAME_Z_TO_A: {
                    return Comparator.comparing(p -> p.getFileName().toString()).reversed();
                }
                case SIZE_SMALL_TO_LARGE: {
                    return Comparator.comparing(p -> p.toFile().length());
                }
                case SIZE_LARGE_TO_SMALL: {
                    return Comparator.comparing(p -> p.toFile().length()).reversed();
                }
            }
            return Comparator.comparing(Function.identity());
        }

        public SourceResponse read(ItemFactory itemFactory) {
            if (this.files.isEmpty()) {
                return SourceResponse.done();
            }
            Path p = this.files.poll();
            this.log().info("Processing {}", (Object)p);
            Item item = itemFactory.create();
            item.getProperties().set("source", (Object)p);
            item.createContent(FileContent.class).withData((Object)p.toFile()).save();
            return SourceResponse.ok();
        }
    }
}

