/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.Settings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mgrs
extends AbstractTextProcessor {
    private static final Pattern mgrsPattern = Pattern.compile("\\b(([1-9]|[1-5][0-9]|60)\\h*([C-HJ-NP-X])\\h*[A-HJ-NP-Z][A-HJ-NP-V]\\h*(([0-9]{5}\\h*[0-9]{5})|([0-9]{4}\\h*[0-9]{4})|([0-9]{3}\\h*[0-9]{3})|([0-9]{2}\\h*[0-9]{2})|([0-9]\\h*[0-9])))\\b");
    private static final Pattern datesPattern = Pattern.compile("([0-2]?[0-9]|3[01])\\h*(JAN|FEB|MAR|JUN|JUL|SEP|DEC)\\h*([0-9]{2}|[0-9]{4})");
    private MgrsSettings settings;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        this.settings = (MgrsSettings)context.getSettings(MgrsSettings.class, (Settings)new MgrsSettings(false));
    }

    protected void process(Item item, Text content) {
        Matcher m = mgrsPattern.matcher((CharSequence)content.getData());
        while (m.find()) {
            Matcher mDates;
            String coordinates = m.group();
            if (this.settings.isIgnoreDates() && (mDates = datesPattern.matcher(coordinates)).matches()) {
                this.log().info("Discarding possible MGRS coordinate {} as it resembles a date", (Object)coordinates);
                continue;
            }
            ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(m.start(), m.end())).withType("entity/coordinate")).withProperty("coordinateType", (Object)"MGRS")).withProperty("value", (Object)coordinates.replaceAll("\\h+", ""))).save();
        }
    }

    public static class MgrsSettings
    implements Settings {
        private final boolean ignoreDates;

        public MgrsSettings(boolean ignoreDates) {
            this.ignoreDates = ignoreDates;
        }

        public boolean isIgnoreDates() {
            return this.ignoreDates;
        }

        public boolean validate() {
            return true;
        }
    }
}

