/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import com.google.openlocationcode.OpenLocationCode;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Plus Code")
@ComponentDescription(value="Extracts full global Plus Codes (also known as Open Location Codes) from text")
public class PlusCode
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/coordinate", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        public Processor() {
            super(Pattern.compile("\\b([23456789C][23456789CFGHJMPQRV][23456789CFGHJMPQRVWX]{6}\\+[23456789CFGHJMPQRVWX]{2,3})\\b", 2), 0, "entity/coordinate");
        }

        protected boolean acceptMatch(Matcher m) {
            return OpenLocationCode.isValidCode((String)m.group()) && OpenLocationCode.isFullCode((String)m.group());
        }

        protected void addProperties(Annotation.Builder builder, Matcher m) {
            OpenLocationCode.CodeArea ca = OpenLocationCode.decode((String)m.group());
            ((Annotation.Builder)builder.withProperty("coordinateType", (Object)"Plus Code")).withProperty("value", (Object)ca);
        }
    }
}

