/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="LatLon")
@ComponentDescription(value="Extract latitude-longitude pairs from text")
@SettingsClass(value=Settings.class)
public class LatLon
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.isLonLat(), settings.getMinDP());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/coordinate", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private boolean lonLat = false;
        private int minDP = 2;

        public boolean validate() {
            return true;
        }

        @Description(value="Is the order of coordinates Longitude first (true) or Latitude first (false)")
        public boolean isLonLat() {
            return this.lonLat;
        }

        public void setLonLat(boolean lonLat) {
            this.lonLat = lonLat;
        }

        @Description(value="The minimum number of decimal places required when parsing decimal degrees")
        public int getMinDP() {
            return this.minDP;
        }

        public void setMinDP(int minDP) {
            this.minDP = minDP;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Pattern llDMSPattern = Pattern.compile("\\b(\\d{1,3})\u00b0(\\d{1,2})'(\\d{1,2}(\\.\\d+)?)\"([NSEW])[,/\\h]*(\\d{1,3})\u00b0(\\d{1,2})'(\\d{1,2}(\\.\\d+)?)\"([NSEW])\\b");
        private final Pattern llDMSSpacePattern = Pattern.compile("\\b(\\d{1,3}) (\\d{1,2}) (\\d{1,2}(\\.\\d+)?) ([NSEW])[,/\\h]*(\\d{1,3}) (\\d{1,2}) (\\d{1,2}(\\.\\d+)?) ([NSEW])\\b");
        private final Pattern llDMSNumericPattern = Pattern.compile("\\b(\\d{2,3})(\\d{2})(\\d{2})?( )?([NSEW])[,/\\h]*(\\d{2,3})(\\d{2})(\\d{2})?( )?([NSEW])\\b");
        private final Pattern llDMSPunctuationPattern = Pattern.compile("\\b(\\d{2,3})-(\\d{2}),(\\d{2})?( )?([NSEW])[,/\\h]*(\\d{2,3})-(\\d{2}),(\\d{2})?( )?([NSEW])\\b");
        private final Pattern llDMSTextPattern = Pattern.compile("\\b((lat|latitude)\\h*)?(\\d{1,2})\u00b0\\h*(\\d{1,2}(\\.\\d+)?)'(\\h*(\\d{1,2}(\\.\\d+)?)\")?\\h*([NS])\\.?,?\\h*(lon|long|longitude)?\\h*(\\d{1,3})\u00b0\\h*(\\d{1,2}(\\.\\d+)?)'(\\h*(\\d{1,2}(\\.\\d+)?)\")?\\h*([EW])\\b", 2);
        private final Pattern llDMTextPattern = Pattern.compile("\\b((lat|latitude)\\h*)?(\\d{1,2})\u00b0\\h*(\\d{1,2})'\\.(\\d+)\\h*([NS])\\.?,?\\h*(lon|long|longitude)?\\h*(\\d{1,3})\u00b0\\h*(\\d{1,2})'\\.(\\d+)\\h*([EW])\\b", 2);
        private final Pattern llDDPattern;
        private final Pattern llDDSymPattern;
        private final Pattern llDDCardPattern;
        private final boolean lonLat;
        private final List<String> currencySymbols = Arrays.asList("\u00a3", "$", "\u20ac");
        private static final String COULD_NOT_PARSE = "Couldn't parse extracted coordinates - coordinate will be skipped";

        public Processor(boolean lonLat, int minDP) {
            this.lonLat = lonLat;
            if (minDP == 0) {
                this.llDDPattern = Pattern.compile("(-?\\d{1,3}(\\.\\d+)?)(,\\h*|\\h+)(-?\\d{1,3}(\\.\\d+)?)");
                this.llDDSymPattern = Pattern.compile("(-?\\d{1,3}(\\.\\d+)?)\u00b0(,\\h*|\\h+)(-?\\d{1,3}(\\.\\d+)?)\u00b0");
                this.llDDCardPattern = Pattern.compile("\\b(\\d{1,3}(\\.\\d+)?)\u00b0( )?([NSEW])(,\\h*|\\h+)(\\d{1,3}(\\.\\d+)?)\u00b0( )?([NSEW])");
            } else {
                this.llDDPattern = Pattern.compile("(-?\\d{1,3}(\\.\\d{" + minDP + ",}))(,\\h*|\\h+)(-?\\d{1,3}(\\.\\d{" + minDP + ",}))");
                this.llDDSymPattern = Pattern.compile("(-?\\d{1,3}(\\.\\d{" + minDP + ",}))\u00b0(,\\h*|\\h+)(-?\\d{1,3}(\\.\\d{" + minDP + ",}))\u00b0");
                this.llDDCardPattern = Pattern.compile("\\b(\\d{1,3}(\\.\\d{" + minDP + ",}))\u00b0( )?([NSEW])(,\\h*|\\h+)(\\d{1,3}(\\.\\d{" + minDP + ",}))\u00b0( )?([NSEW])");
            }
        }

        protected void process(Text content) {
            HashSet<String> found = new HashSet<String>();
            String text = Processor.normalizeQuotesAndDots((String)content.getData());
            this.processDD(content, text, found);
            this.processDDCard(content, text, found);
            this.processDMS(content, text, found);
            this.processDMSText(content, text, found);
        }

        private void processDD(Text content, String text, Set<String> found) {
            Pattern[] patterns;
            for (Pattern p : patterns = new Pattern[]{this.llDDPattern, this.llDDSymPattern}) {
                Matcher matcher = p.matcher(text);
                while (matcher.find()) {
                    if (this.currencySymbols.contains(text.substring(matcher.start(1) - 1, matcher.start(1)))) {
                        this.log().info("Skipping coordinate as it is preceded by a currency symbol");
                        continue;
                    }
                    try {
                        double lon;
                        double lat;
                        if (!this.lonLat) {
                            lat = Double.parseDouble(matcher.group(1));
                            lon = Double.parseDouble(matcher.group(4));
                        } else {
                            lon = Double.parseDouble(matcher.group(1));
                            lat = Double.parseDouble(matcher.group(4));
                        }
                        this.addCoordinate(content, matcher.start(), matcher.end(), lon, lat, "dd", found);
                    }
                    catch (NumberFormatException e) {
                        this.log().warn(COULD_NOT_PARSE, (Throwable)e);
                    }
                }
            }
        }

        private void processDDCard(Text content, String text, Set<String> found) {
            Matcher matcher = this.llDDCardPattern.matcher(text);
            while (matcher.find()) {
                if (this.isInvalidPair(matcher.group(4), matcher.group(9))) continue;
                try {
                    Double lat = Double.parseDouble(matcher.group(1));
                    Double lon = Double.parseDouble(matcher.group(6));
                    if ("E".equals(matcher.group(4)) || "W".equals(matcher.group(4))) {
                        Double tmp = lat;
                        lat = lon;
                        lon = tmp;
                    }
                    if (this.flipLon(matcher.group(4), matcher.group(9))) {
                        lon = -lon.doubleValue();
                    }
                    if (this.flipLat(matcher.group(4), matcher.group(9))) {
                        lat = -lat.doubleValue();
                    }
                    this.addCoordinate(content, matcher.start(), matcher.end(), lon, lat, "dd", found);
                }
                catch (NumberFormatException e) {
                    this.log().warn(COULD_NOT_PARSE, (Throwable)e);
                }
            }
        }

        private void processDMS(Text content, String text, Set<String> found) {
            Pattern[] patterns;
            for (Pattern p : patterns = new Pattern[]{this.llDMSPattern, this.llDMSSpacePattern, this.llDMSNumericPattern, this.llDMSPunctuationPattern}) {
                Matcher matcher = p.matcher(text);
                while (matcher.find()) {
                    if (this.isInvalidPair(matcher.group(5), matcher.group(10))) continue;
                    try {
                        double[] lonLat = this.determineLonLatDMS(matcher);
                        this.addCoordinate(content, matcher.start(), matcher.end(), lonLat[0], lonLat[1], "dms", found);
                    }
                    catch (NumberFormatException e) {
                        this.log().warn(COULD_NOT_PARSE, (Throwable)e);
                    }
                }
            }
        }

        private void processDMSText(Text content, String text, Set<String> found) {
            double lon;
            double lat;
            Matcher m = this.llDMSTextPattern.matcher(text);
            while (m.find()) {
                lat = Double.parseDouble(m.group(3));
                lat += Double.parseDouble(m.group(4)) / 60.0;
                if (m.group(7) != null) {
                    lat += Double.parseDouble(m.group(7)) / 3600.0;
                }
                if ("S".equalsIgnoreCase(m.group(9))) {
                    lat = -lat;
                }
                lon = Double.parseDouble(m.group(11));
                lon += Double.parseDouble(m.group(12)) / 60.0;
                if (m.group(15) != null) {
                    lon += Double.parseDouble(m.group(15)) / 3600.0;
                }
                if ("W".equalsIgnoreCase(m.group(17))) {
                    lon = -lon;
                }
                this.addCoordinate(content, m.start(), m.end(), lon, lat, "dms", found);
            }
            m = this.llDMTextPattern.matcher(text);
            while (m.find()) {
                lat = Double.parseDouble(m.group(3));
                lat += Double.parseDouble(m.group(4)) / 60.0;
                lat += Double.parseDouble(m.group(5)) / 3600.0;
                if ("S".equalsIgnoreCase(m.group(6))) {
                    lat = -lat;
                }
                lon = Double.parseDouble(m.group(8));
                lon += Double.parseDouble(m.group(9)) / 60.0;
                lon += Double.parseDouble(m.group(10)) / 3600.0;
                if ("S".equalsIgnoreCase(m.group(11))) {
                    lon = -lon;
                }
                this.addCoordinate(content, m.start(), m.end(), lon, lat, "dms", found);
            }
        }

        private double[] determineLonLatDMS(Matcher matcher) {
            double lat = this.dmsToDeg(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), this.parseOrNull(matcher.group(3)));
            double lon = this.dmsToDeg(Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), this.parseOrNull(matcher.group(8)));
            if ("E".equals(matcher.group(5)) || "W".equals(matcher.group(5))) {
                Double tmp = lat;
                lat = lon;
                lon = tmp;
            }
            if (this.flipLon(matcher.group(5), matcher.group(10))) {
                lon = -lon;
            }
            if (this.flipLat(matcher.group(5), matcher.group(10))) {
                lat = -lat;
            }
            return new double[]{lon, lat};
        }

        private boolean isInvalidPair(String ... parameters) {
            boolean nFound = false;
            boolean eFound = false;
            for (String s : parameters) {
                if ("N".equalsIgnoreCase(s) || "S".equalsIgnoreCase(s)) {
                    nFound = true;
                    continue;
                }
                if (!"E".equalsIgnoreCase(s) && !"W".equalsIgnoreCase(s)) continue;
                eFound = true;
            }
            return !nFound || !eFound;
        }

        private boolean flipLat(String ... parameters) {
            for (String s : parameters) {
                if (!"S".equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        private boolean flipLon(String ... parameters) {
            for (String s : parameters) {
                if (!"W".equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        private double dmsToDeg(Integer d, Integer m, Double s) {
            double seconds = (double)m.intValue() * 60.0;
            if (s != null) {
                seconds += s.doubleValue();
            }
            return (double)d.intValue() + seconds / 3600.0;
        }

        private Double parseOrNull(String s) {
            if (s != null) {
                return Double.parseDouble(s);
            }
            return null;
        }

        private void addCoordinate(Text content, int begin, int end, double lon, double lat, String coordinateType, Set<String> found) {
            String textLoc;
            if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0 && found.add(textLoc = begin + "," + end)) {
                String coords = "[" + lon + "," + lat + "]";
                ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(begin, end)).withType("entity/coordinate")).withProperty("coordinateType", (Object)coordinateType)).withProperty("geojson", (Object)("{\"type\":\"Point\",\"coordinates\":" + coords + "}"))).withProperty("value", (Object)(lat + ";" + lon))).withProperty("longitude", (Object)lon)).withProperty("latitude", (Object)lat)).save();
            }
        }

        public static String normalizeQuotesAndDots(String s) {
            return s.replaceAll("[\\u201C\\u201D\\u2033\\u02BA\\u301E\\u3003]", "\"").replaceAll("[\\u2018\\u2019\\u2032\\u00B4\\u02B9`]", "'").replaceAll("[\\u00B7]", ".");
        }
    }
}

