/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.gazetteers.processors.AhoCorasick;
import io.annot8.components.gazetteers.processors.Gazetteer;
import io.annot8.components.gazetteers.processors.impl.MapGazetteer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

@ComponentName(value="CountryGazetteer")
@ComponentDescription(value="Extract countries from text")
@SettingsClass(value=Settings.class)
public class CountryGazetteer
extends AhoCorasick<Settings> {
    protected AhoCorasick.Processor createComponent(Context context, Settings countryGazetteerSettings) {
        return new AhoCorasick.Processor((Gazetteer)new MapGazetteer(this.getCountryData(countryGazetteerSettings)), (AhoCorasick.Settings)countryGazetteerSettings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/location", SpanBounds.class).build();
    }

    private void addGeojsonsToMetadata(Map<Set<String>, Map<String, Object>> countries) {
        Map<String, JsonObject> geojsons = this.getGeojsons();
        countries.values().forEach(metadata -> metadata.put("geojson", geojsons.get(metadata.get("cca3").toString())));
    }

    private Map<Set<String>, Map<String, Object>> getCountryData(Settings settings) {
        HashMap<Set<String>, Map<String, Object>> output = new HashMap<Set<String>, Map<String, Object>>();
        Json.createReader((InputStream)CountryGazetteer.class.getResourceAsStream("countries.json")).readArray().forEach(jv -> {
            JsonObject jo = jv.asJsonObject();
            Set<String> names = this.getNames(jo);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("cca3", jo.getString("cca3"));
            if (settings.isMetadata()) {
                this.addJsonMetadata(jo, metadata);
            }
            output.put(names, metadata);
        });
        if (settings.isGeojson()) {
            this.addGeojsonsToMetadata(output);
        }
        return output;
    }

    private Map<String, JsonObject> getGeojsons() {
        HashMap<String, JsonObject> output = new HashMap<String, JsonObject>();
        JsonReader reader = Json.createReader((InputStream)CountryGazetteer.class.getResourceAsStream("countries.geojson"));
        reader.readObject().getJsonArray("features").forEach(feature -> output.put(feature.asJsonObject().getJsonObject("properties").getString("ISO_A3"), feature.asJsonObject().getJsonObject("geometry")));
        return output;
    }

    private void addJsonMetadata(JsonObject jo, Map<String, Object> metadata) {
        metadata.put("area", jo.getInt("area"));
        metadata.put("borders", jo.getJsonArray("borders").stream().map(JsonValue::toString).map(this::removeQuotes).collect(Collectors.toSet()));
        metadata.put("capitals", jo.getJsonArray("capital").stream().map(JsonValue::toString).map(this::removeQuotes).collect(Collectors.toSet()));
        metadata.put("demonym", jo.getString("demonym"));
        metadata.put("flag", jo.getString("flag"));
        metadata.put("independent", jo.getBoolean("independent"));
        metadata.put("landlocked", jo.getBoolean("landlocked"));
        List latlng = jo.getJsonArray("latlng").stream().map(JsonValue::toString).map(Double::parseDouble).collect(Collectors.toList());
        metadata.put("latitude", latlng.get(0));
        metadata.put("longitude", latlng.get(1));
        metadata.put("region", jo.getString("region"));
        metadata.put("subregion", jo.getString("subregion"));
    }

    private Set<String> getNames(JsonObject jo) {
        Set initialSet = jo.getJsonObject("name").getJsonObject("native").values().stream().flatMap(a -> a.asJsonObject().values().stream().map(JsonValue::toString)).collect(Collectors.toSet());
        initialSet.add(jo.getJsonObject("name").getString("common"));
        initialSet.add(jo.getJsonObject("name").getString("official"));
        jo.getJsonObject("translations").values().forEach(a -> this.addNamesToSet(initialSet, a.asJsonObject()));
        jo.getJsonArray("altSpellings").forEach(s -> initialSet.add(s.toString()));
        return initialSet.stream().map(this::removeQuotes).collect(Collectors.toSet());
    }

    private String removeQuotes(String input) {
        return input.replaceAll("\"", "");
    }

    private void addNamesToSet(Set<String> runningSet, JsonObject jo) {
        runningSet.add(jo.getString("common"));
        runningSet.add(jo.getString("official"));
    }

    public static class Settings
    extends AhoCorasick.Settings {
        private boolean geojson;
        private boolean metadata;

        @JsonbCreator
        public Settings(@JsonbProperty(value="geojson") boolean geojson, @JsonbProperty(value="metadata") boolean metadata) {
            this.geojson = geojson;
            this.metadata = metadata;
            this.setAdditionalData(true);
            this.setCaseSensitive(true);
            this.setExactWhitespace(false);
            this.setPlurals(false);
            this.setType("entity/location");
        }

        @Description(value="Add GeoJSON information to annotations?")
        public boolean isGeojson() {
            return this.geojson;
        }

        @Description(value="Add country metadata to annotations?")
        public boolean isMetadata() {
            return this.metadata;
        }

        public boolean validate() {
            return true;
        }
    }
}

