/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

@ComponentName(value="Nationality")
@ComponentDescription(value="Extract nationality demonyms, e.g. French, from text")
public class Nationality
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/nationality", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private Map<String, Pattern> countryPatterns = new HashMap<String, Pattern>();
        private Map<String, String> countryCodes = new HashMap<String, String>();

        public Processor() {
            JsonReader reader = Json.createReader((InputStream)Nationality.class.getResourceAsStream("countries.json"));
            reader.readArray().forEach(jv -> {
                JsonObject jo = jv.asJsonObject();
                String countryDemonym = jo.getString("demonym").toLowerCase();
                String countryCode = jo.getString("cca3");
                if (countryDemonym.length() > 1) {
                    Pattern p = Pattern.compile("\\b" + countryDemonym + "\\b", 2);
                    this.countryPatterns.put(countryDemonym, p);
                    this.countryCodes.put(countryDemonym, countryCode);
                }
            });
        }

        protected void process(Text content) {
            for (Map.Entry<String, Pattern> e : this.countryPatterns.entrySet()) {
                Matcher m = e.getValue().matcher((CharSequence)content.getData());
                String countryCode = this.countryCodes.get(e.getKey());
                while (m.find()) {
                    ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withType("entity/nationality")).withBounds((Bounds)new SpanBounds(m.start(), m.end())).withProperty("nationality", (Object)e.getKey())).withProperty("countryCode", (Object)countryCode)).save();
                }
            }
        }
    }
}

