/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import com.opencsv.bean.CsvBindAndSplitByPosition;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.gazetteers.processors.AhoCorasick;
import io.annot8.components.gazetteers.processors.Gazetteer;
import io.annot8.components.gazetteers.processors.impl.MapGazetteer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ComponentName(value="GeoNames Gazetteer")
@ComponentDescription(value="Use downloaded GeoNames data as a gazetteer to identify locations")
@SettingsClass(value=Settings.class)
public class GeoNamesGazetteer
extends AbstractProcessorDescriptor<AhoCorasick.Processor, Settings> {
    protected AhoCorasick.Processor createComponent(Context context, Settings settings) {
        AhoCorasick.Settings s = new AhoCorasick.Settings();
        s.setAdditionalData(true);
        s.setCaseSensitive(settings.isCaseSensitive());
        s.setExactWhitespace(false);
        s.setPlurals(false);
        s.setSubType(settings.getSubType());
        s.setType("entity/location");
        try {
            return new AhoCorasick.Processor((Gazetteer)new MapGazetteer(this.loadGazetteer(settings.getGeonamesFile(), settings.getAdditionalProperties(), settings.isGeoJson(), settings.getMinimumPopulation())), s);
        }
        catch (IOException e) {
            throw new Annot8RuntimeException("Unable to read GeoNames file into gazetteer", (Throwable)e);
        }
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/location", SpanBounds.class).withCreatesGroups("aliases").build();
    }

    private Map<Set<String>, Map<String, Object>> loadGazetteer(File f, Settings.GeoNamesAdditionalProperties additionalProperties, boolean geoJson, int minPopulation) throws IOException {
        HashMap<Set<String>, Map<String, Object>> gazetteer = new HashMap<Set<String>, Map<String, Object>>();
        try (FileReader reader = new FileReader(f);){
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withSeparator('\t').withIgnoreQuotations(true).withType(GeoNamesBean.class).build();
            for (GeoNamesBean bean : csvToBean) {
                if (bean.getPopulation() == null ? minPopulation > 0 : bean.getPopulation() < minPopulation) continue;
                HashSet<String> names = new HashSet<String>();
                names.add(bean.getName());
                names.add(bean.getAsciiName());
                names.addAll(bean.getAlternateNames());
                HashMap<String, Object> props = new HashMap<String, Object>();
                switch (additionalProperties) {
                    case ALL: {
                        this.putIfNotNull(props, "identifier", bean.getGeonameId());
                        this.putIfNotNull(props, "lastUpdated", bean.getModificationDate());
                    }
                    case EXTENDED: {
                        this.putIfNotNull(props, "admin1Code", bean.getAdmin1Code());
                        this.putIfNotNull(props, "admin2Code", bean.getAdmin2Code());
                        this.putIfNotNull(props, "admin3Code", bean.getAdmin3Code());
                        this.putIfNotNull(props, "admin4Code", bean.getAdmin4Code());
                        this.putIfNotNull(props, "cc2", bean.getCc2());
                        if (bean.getDem() != null && !bean.getDem().equals(-9999)) {
                            props.put("dem", bean.getPopulation());
                        }
                        this.putIfNotNull(props, "elevation", bean.getElevation());
                        this.putIfNotNull(props, "featureClass", bean.getFeatureClass());
                        this.putIfNotNull(props, "featureCode", bean.getFeatureCode());
                        this.putIfNotNull(props, "population", bean.getPopulation());
                        this.putIfNotNull(props, "timezone", bean.getTimezone());
                    }
                    case BASIC: {
                        this.putIfNotNull(props, "country", bean.getCountryCode());
                        this.putIfNotNull(props, "latitude", bean.getLatitude());
                        this.putIfNotNull(props, "longitude", bean.getLongitude());
                    }
                }
                if (geoJson && bean.getLatitude() != null && bean.getLongitude() != null) {
                    props.put("geojson", "{\"type\":\"Point\",\"coordinates\":[" + bean.getLongitude() + "," + bean.getLatitude() + "]}");
                }
                gazetteer.put(names, props);
            }
        }
        return gazetteer;
    }

    private void putIfNotNull(Map<String, Object> m, String k, Object v) {
        if (v != null) {
            m.put(k, v);
        }
    }

    private void putIfNotNull(Map<String, Object> m, String k, String s) {
        if (s != null && !s.isBlank()) {
            m.put(k, s);
        }
    }

    private void putIfNotNull(Map<String, Object> m, String k, List<String> l) {
        if (l == null || l.isEmpty()) {
            return;
        }
        List fl = l.stream().filter(s -> !s.isBlank()).collect(Collectors.toList());
        if (!fl.isEmpty()) {
            m.put(k, fl);
        }
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private GeoNamesAdditionalProperties additionalProperties = GeoNamesAdditionalProperties.BASIC;
        private boolean caseSensitive = true;
        private boolean geoJson = true;
        private File geonamesFile = null;
        private String subType = null;
        private int minimumPopulation = 0;

        public boolean validate() {
            return this.geonamesFile != null && this.geonamesFile.exists() && this.geonamesFile.isFile() && this.geonamesFile.canRead();
        }

        @Description(value="Which fields from the GeoNames data should be added as additional properties", defaultValue="BASIC")
        public GeoNamesAdditionalProperties getAdditionalProperties() {
            return this.additionalProperties;
        }

        public void setAdditionalProperties(GeoNamesAdditionalProperties additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @Description(value="Only annotate matches with the same case as the data file", defaultValue="true")
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Description(value="Add GeoJSON to the annotation", defaultValue="true")
        public boolean isGeoJson() {
            return this.geoJson;
        }

        public void setGeoJson(boolean geoJson) {
            this.geoJson = geoJson;
        }

        @Description(value="Location of the GeoNames data file")
        public File getGeonamesFile() {
            return this.geonamesFile;
        }

        public void setGeonamesFile(File geonamesFile) {
            this.geonamesFile = geonamesFile;
        }

        @Description(value="Sub-type to assign to annotations, or null")
        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        @Description(value="Entries in GeoNames under this size will be excluded")
        public int getMinimumPopulation() {
            return this.minimumPopulation;
        }

        public void setMinimumPopulation(int minimumPopulation) {
            this.minimumPopulation = minimumPopulation;
        }

        public static enum GeoNamesAdditionalProperties {
            NONE,
            EXTENDED,
            BASIC,
            ALL;

        }
    }

    public static class GeoNamesBean {
        @CsvBindByPosition(position=0)
        private Long geonameId;
        @CsvBindByPosition(position=1)
        private String name;
        @CsvBindByPosition(position=2)
        private String asciiName;
        @CsvBindAndSplitByPosition(position=3, splitOn=",", elementType=String.class)
        private List<String> alternateNames;
        @CsvBindByPosition(position=4)
        private Double latitude;
        @CsvBindByPosition(position=5)
        private Double longitude;
        @CsvBindByPosition(position=6)
        private String featureClass;
        @CsvBindByPosition(position=7)
        private String featureCode;
        @CsvBindByPosition(position=8)
        private String countryCode;
        @CsvBindAndSplitByPosition(position=9, splitOn=",", elementType=String.class)
        private List<String> cc2;
        @CsvBindByPosition(position=10)
        private String admin1Code;
        @CsvBindByPosition(position=11)
        private String admin2Code;
        @CsvBindByPosition(position=12)
        private String admin3Code;
        @CsvBindByPosition(position=13)
        private String admin4Code;
        @CsvBindByPosition(position=14)
        private Integer population;
        @CsvBindByPosition(position=15)
        private Integer elevation;
        @CsvBindByPosition(position=16)
        private Integer dem;
        @CsvBindByPosition(position=17)
        private String timezone;
        @CsvBindByPosition(position=18)
        @CsvDate(value="yyyy-MM-dd")
        private LocalDate modificationDate;

        public Long getGeonameId() {
            return this.geonameId;
        }

        public void setGeonameId(Long geonameId) {
            this.geonameId = geonameId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAsciiName() {
            return this.asciiName;
        }

        public void setAsciiName(String asciiName) {
            this.asciiName = asciiName;
        }

        public List<String> getAlternateNames() {
            return this.alternateNames;
        }

        public void setAlternateNames(List<String> alternateNames) {
            this.alternateNames = alternateNames;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public String getFeatureClass() {
            return this.featureClass;
        }

        public void setFeatureClass(String featureClass) {
            this.featureClass = featureClass;
        }

        public String getFeatureCode() {
            return this.featureCode;
        }

        public void setFeatureCode(String featureCode) {
            this.featureCode = featureCode;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public List<String> getCc2() {
            return this.cc2;
        }

        public void setCc2(List<String> cc2) {
            this.cc2 = cc2;
        }

        public String getAdmin1Code() {
            return this.admin1Code;
        }

        public void setAdmin1Code(String admin1Code) {
            this.admin1Code = admin1Code;
        }

        public String getAdmin2Code() {
            return this.admin2Code;
        }

        public void setAdmin2Code(String admin2Code) {
            this.admin2Code = admin2Code;
        }

        public String getAdmin3Code() {
            return this.admin3Code;
        }

        public void setAdmin3Code(String admin3Code) {
            this.admin3Code = admin3Code;
        }

        public String getAdmin4Code() {
            return this.admin4Code;
        }

        public void setAdmin4Code(String admin4Code) {
            this.admin4Code = admin4Code;
        }

        public Integer getPopulation() {
            return this.population;
        }

        public void setPopulation(Integer population) {
            this.population = population;
        }

        public Integer getElevation() {
            return this.elevation;
        }

        public void setElevation(Integer elevation) {
            this.elevation = elevation;
        }

        public Integer getDem() {
            return this.dem;
        }

        public void setDem(Integer dem) {
            this.dem = dem;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public LocalDate getModificationDate() {
            return this.modificationDate;
        }

        public void setModificationDate(LocalDate modificationDate) {
            this.modificationDate = modificationDate;
        }
    }
}

