/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.components.geo.processors.geonames.GeoNamesAdditionalProperties;
import io.annot8.components.geo.processors.geonames.GeoNamesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@ComponentName(value="Enrich with GeoNames")
@ComponentDescription(value="Add information to previously extracted Locations from the GeoNames database")
@SettingsClass(value=Settings.class)
public class EnrichWithGeoNames
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesAnnotations("entity/location", SpanBounds.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private File geonamesFile = null;
        private GeoNamesAdditionalProperties properties = GeoNamesAdditionalProperties.BASIC;
        private boolean geoJson = true;

        public boolean validate() {
            return this.properties != null && this.geonamesFile != null;
        }

        @Description(value="Location of the GeoNames data file")
        public File getGeonamesFile() {
            return this.geonamesFile;
        }

        public void setGeonamesFile(File geonamesFile) {
            this.geonamesFile = geonamesFile;
        }

        @Description(value="Which fields from the GeoNames data should be added to annotations", defaultValue="BASIC")
        public GeoNamesAdditionalProperties getProperties() {
            return this.properties;
        }

        public void setProperties(GeoNamesAdditionalProperties properties) {
            this.properties = properties;
        }

        @Description(value="Add GeoJSON to the annotation", defaultValue="true")
        public boolean isGeoJson() {
            return this.geoJson;
        }

        public void setGeoJson(boolean geoJson) {
            this.geoJson = geoJson;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Map<String, Integer> geonameEntryToId = new HashMap<String, Integer>();
        private final Map<Integer, Map<String, Object>> idToProperties = new HashMap<Integer, Map<String, Object>>();

        public Processor(Settings settings) {
            try {
                AtomicInteger l = new AtomicInteger(0);
                GeoNamesUtils.loadGazetteer(settings.getGeonamesFile(), settings.getProperties(), settings.isGeoJson(), 0).forEach((set, properties) -> {
                    int id = l.getAndIncrement();
                    set.forEach(s -> this.geonameEntryToId.putIfAbsent((String)s, id));
                    if (!properties.isEmpty()) {
                        this.idToProperties.put(id, (Map<String, Object>)properties);
                    }
                });
            }
            catch (IOException e) {
                throw new BadConfigurationException("Unable to load GeoNames from configuration", (Throwable)e);
            }
        }

        public ProcessorResponse process(Item item) {
            item.getContents().forEach(c -> c.getAnnotations().getByBoundsAndType(SpanBounds.class, "entity/location").forEach(a -> {
                HashSet values = new HashSet();
                a.getProperties().get("value", String.class).ifPresent(values::add);
                a.getBounds(SpanBounds.class).flatMap(sb -> sb.getData(c, String.class)).ifPresent(values::add);
                values.stream().filter(this.geonameEntryToId::containsKey).findFirst().ifPresent(s -> {
                    Map<String, Object> props = this.idToProperties.getOrDefault(this.geonameEntryToId.get(s), Collections.emptyMap());
                    Annotation.Builder b = c.getAnnotations().edit(a);
                    props.forEach((arg_0, arg_1) -> ((Annotation.Builder)b).withProperty(arg_0, arg_1));
                    b.save();
                });
            }));
            return ProcessorResponse.ok();
        }
    }
}

