/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.gazetteers.processors.AhoCorasick;
import io.annot8.components.gazetteers.processors.Gazetteer;
import io.annot8.components.gazetteers.processors.impl.MapGazetteer;
import io.annot8.components.geo.processors.geonames.GeoNamesAdditionalProperties;
import io.annot8.components.geo.processors.geonames.GeoNamesUtils;
import java.io.File;
import java.io.IOException;

@ComponentName(value="GeoNames Gazetteer")
@ComponentDescription(value="Use downloaded GeoNames data as a gazetteer to identify locations")
@SettingsClass(value=Settings.class)
public class GeoNamesGazetteer
extends AbstractProcessorDescriptor<AhoCorasick.Processor, Settings> {
    protected AhoCorasick.Processor createComponent(Context context, Settings settings) {
        AhoCorasick.Settings s = new AhoCorasick.Settings();
        s.setAdditionalData(true);
        s.setCaseSensitive(settings.isCaseSensitive());
        s.setExactWhitespace(false);
        s.setPlurals(false);
        s.setSubType(settings.getSubType());
        s.setType("entity/location");
        try {
            return new AhoCorasick.Processor((Gazetteer)new MapGazetteer(GeoNamesUtils.loadGazetteer(settings.getGeonamesFile(), settings.getAdditionalProperties(), settings.isGeoJson(), settings.getMinimumPopulation())), s);
        }
        catch (IOException e) {
            throw new Annot8RuntimeException("Unable to read GeoNames file into gazetteer", (Throwable)e);
        }
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/location", SpanBounds.class).withCreatesGroups("aliases").build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private GeoNamesAdditionalProperties additionalProperties = GeoNamesAdditionalProperties.BASIC;
        private boolean caseSensitive = true;
        private boolean geoJson = true;
        private File geonamesFile = null;
        private String subType = null;
        private int minimumPopulation = 0;

        public boolean validate() {
            return this.geonamesFile != null && this.geonamesFile.exists() && this.geonamesFile.isFile() && this.geonamesFile.canRead();
        }

        @Description(value="Which fields from the GeoNames data should be added as additional properties", defaultValue="BASIC")
        public GeoNamesAdditionalProperties getAdditionalProperties() {
            return this.additionalProperties;
        }

        public void setAdditionalProperties(GeoNamesAdditionalProperties additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @Description(value="Only annotate matches with the same case as the data file", defaultValue="true")
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Description(value="Add GeoJSON to the annotation", defaultValue="true")
        public boolean isGeoJson() {
            return this.geoJson;
        }

        public void setGeoJson(boolean geoJson) {
            this.geoJson = geoJson;
        }

        @Description(value="Location of the GeoNames data file")
        public File getGeonamesFile() {
            return this.geonamesFile;
        }

        public void setGeonamesFile(File geonamesFile) {
            this.geonamesFile = geonamesFile;
        }

        @Description(value="Sub-type to assign to annotations, or null")
        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        @Description(value="Entries in GeoNames under this size will be excluded")
        public int getMinimumPopulation() {
            return this.minimumPopulation;
        }

        public void setMinimumPopulation(int minimumPopulation) {
            this.minimumPopulation = minimumPopulation;
        }
    }
}

