/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.gov.dstl.geo.osgb.EastingNorthingConversion;
import uk.gov.dstl.geo.osgb.NationalGrid;
import uk.gov.dstl.geo.osgb.OSGB36;

@ComponentName(value="Ordnance Survey Coordinates")
@ComponentDescription(value="Extract  6, 8 or 10 figure OS coordinates within a document")
public class OSGB
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/coordinate", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private static final Pattern OSGB_PATTERN = Pattern.compile("\\b([HJNOST][A-HJ-Z])( )?([0-9]{6}|[0-9]{3} [0-9]{3}|[0-9]{8}|[0-9]{4} [0-9]{4}|[0-9]{10}|[0-9]{5} [0-9]{5})\\b", 2);

        protected void process(Text content) {
            Matcher m = OSGB_PATTERN.matcher((CharSequence)content.getData());
            while (m.find()) {
                try {
                    double[] en = NationalGrid.fromNationalGrid((String)m.group());
                    double[] latlonOSGB38 = EastingNorthingConversion.toLatLon((double[])en, (double)6377563.396, (double)6356256.909, (double)-100000.0, (double)400000.0, (double)0.9996012717, (double)49.0, (double)-2.0);
                    double[] latlonWGS84 = OSGB36.toWGS84((double)latlonOSGB38[0], (double)latlonOSGB38[1]);
                    String coordinates = String.format("{\"type\": \"Point\", \"coordinates\": [%f,%f]}", latlonWGS84[1], latlonWGS84[0]);
                    ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withType("entity/coordinate")).withBounds((Bounds)new SpanBounds(m.start(), m.end())).withProperty("coordinateType", (Object)"osgb")).withProperty("geojson", (Object)coordinates)).withProperty("latitude", (Object)latlonWGS84[0])).withProperty("longitude", (Object)latlonWGS84[1])).save();
                }
                catch (Exception e) {
                    this.log().debug("Unable to convert OSGB {}", (Object)m.group(), (Object)e);
                }
            }
        }
    }
}

