/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.gazetteers.processors.AhoCorasick;
import io.annot8.components.gazetteers.processors.Gazetteer;
import io.annot8.components.gazetteers.processors.impl.MapGazetteer;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ComponentName(value="Country Gazetteer")
@ComponentDescription(value="Extract countries from text")
@SettingsClass(value=Settings.class)
public class CountryGazetteer
extends AbstractProcessorDescriptor<AhoCorasick.Processor, Settings> {
    protected AhoCorasick.Processor createComponent(Context context, Settings settings) {
        AhoCorasick.Settings s = new AhoCorasick.Settings();
        s.setAdditionalData(true);
        s.setCaseSensitive(settings.isCaseSensitive());
        s.setExactWhitespace(false);
        s.setPlurals(false);
        s.setSubType(settings.getSubType());
        s.setType("entity/location");
        return new AhoCorasick.Processor((Gazetteer)new MapGazetteer(this.getCountryData(settings)), s);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/location", SpanBounds.class).build();
    }

    private void addGeojsonsToMetadata(Map<Set<String>, Map<String, Object>> countries) {
        Map<String, JsonObject> geojsons = this.getGeojsons();
        countries.values().forEach(metadata -> metadata.put("geojson", this.deJsonifyObject((JsonObject)geojsons.get(metadata.get("cca3").toString()))));
    }

    private Map<Set<String>, Map<String, Object>> getCountryData(Settings settings) {
        HashMap<Set<String>, Map<String, Object>> output = new HashMap<Set<String>, Map<String, Object>>();
        Json.createReader((InputStream)CountryGazetteer.class.getResourceAsStream("countries.json")).readArray().forEach(jv -> {
            JsonObject jo = jv.asJsonObject();
            Set<String> names = this.getNames(jo, settings.isIncludeCountryCodes());
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("cca3", jo.getString("cca3"));
            if (settings.isMetadata()) {
                this.addJsonMetadata(jo, metadata);
            }
            output.put(names, metadata);
        });
        if (settings.isGeoJson()) {
            this.addGeojsonsToMetadata(output);
        }
        return output;
    }

    private Map<String, JsonObject> getGeojsons() {
        HashMap<String, JsonObject> output = new HashMap<String, JsonObject>();
        JsonReader reader = Json.createReader((InputStream)CountryGazetteer.class.getResourceAsStream("countries.geojson"));
        reader.readObject().getJsonArray("features").forEach(feature -> output.put(feature.asJsonObject().getJsonObject("properties").getString("ISO_A3"), feature.asJsonObject().getJsonObject("geometry")));
        return output;
    }

    private Map<String, Object> deJsonifyObject(JsonObject jo) {
        if (jo == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        jo.forEach((key, v) -> {
            Object o = this.deJsonifyValue((JsonValue)v);
            if (o != null) {
                m.put((String)key, o);
            }
        });
        return m;
    }

    private Object deJsonifyValue(JsonValue jv) {
        switch (jv.getValueType()) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
            case STRING: {
                return ((JsonString)jv).getString();
            }
            case NUMBER: {
                return ((JsonNumber)jv).numberValue();
            }
            case ARRAY: {
                return jv.asJsonArray().stream().map(this::deJsonifyValue).collect(Collectors.toList());
            }
            case OBJECT: {
                return this.deJsonifyObject(jv.asJsonObject());
            }
        }
        return null;
    }

    private void addJsonMetadata(JsonObject jo, Map<String, Object> metadata) {
        metadata.put("area", jo.getInt("area"));
        metadata.put("borders", jo.getJsonArray("borders").stream().map(JsonValue::toString).map(this::removeQuotes).collect(Collectors.toSet()));
        metadata.put("capitals", jo.getJsonArray("capital").stream().map(JsonValue::toString).map(this::removeQuotes).collect(Collectors.toSet()));
        try {
            metadata.put("demonym", jo.getJsonObject("demonyms").getJsonObject("eng").getString("m"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        metadata.put("flag", jo.getString("flag"));
        try {
            metadata.put("independent", jo.getBoolean("independent"));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        metadata.put("landlocked", jo.getBoolean("landlocked"));
        List latlng = jo.getJsonArray("latlng").stream().map(JsonValue::toString).map(Double::parseDouble).collect(Collectors.toList());
        metadata.put("latitude", latlng.get(0));
        metadata.put("longitude", latlng.get(1));
        metadata.put("region", jo.getString("region"));
        metadata.put("subregion", jo.getString("subregion"));
    }

    private Set<String> getNames(JsonObject jo, boolean includeCountryCodes) {
        Set initialSet = jo.getJsonObject("name").getJsonObject("native").values().stream().flatMap(a -> a.asJsonObject().values().stream().map(JsonValue::toString)).collect(Collectors.toSet());
        initialSet.add(jo.getJsonObject("name").getString("common"));
        initialSet.add(jo.getJsonObject("name").getString("official"));
        jo.getJsonObject("translations").values().forEach(a -> this.addNamesToSet(initialSet, a.asJsonObject()));
        jo.getJsonArray("altSpellings").forEach(s -> initialSet.add(s.toString()));
        return initialSet.stream().map(this::removeQuotes).filter(s -> includeCountryCodes || s.length() > 2).collect(Collectors.toSet());
    }

    private String removeQuotes(String input) {
        return input.replaceAll("\"", "");
    }

    private void addNamesToSet(Set<String> runningSet, JsonObject jo) {
        runningSet.add(jo.getString("common"));
        runningSet.add(jo.getString("official"));
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private boolean caseSensitive = true;
        private boolean geoJson = true;
        private boolean metadata = false;
        private boolean includeCountryCodes = false;
        private String subType;

        public Settings() {
        }

        public Settings(boolean geoJson, boolean metadata) {
            this.geoJson = geoJson;
            this.metadata = metadata;
        }

        public Settings(boolean geoJson, boolean metadata, boolean caseSensitive, String subType, boolean includeCountryCodes) {
            this.geoJson = geoJson;
            this.metadata = metadata;
            this.caseSensitive = caseSensitive;
            this.subType = subType;
            this.includeCountryCodes = includeCountryCodes;
        }

        @Description(value="Only annotate matches with the same case as the data file", defaultValue="true")
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Description(value="Add GeoJSON information to annotations", defaultValue="true")
        public boolean isGeoJson() {
            return this.geoJson;
        }

        public void setGeoJson(boolean geoJson) {
            this.geoJson = geoJson;
        }

        @Description(value="Add country metadata to annotations", defaultValue="false")
        public boolean isMetadata() {
            return this.metadata;
        }

        public void setMetadata(boolean metadata) {
            this.metadata = metadata;
        }

        @Description(value="Sub-type to assign to annotations, or null")
        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        @Description(value="Include two letter country codes in list of country names", defaultValue="false")
        public boolean isIncludeCountryCodes() {
            return this.includeCountryCodes;
        }

        public void setIncludeCountryCodes(boolean includeCountryCodes) {
            this.includeCountryCodes = includeCountryCodes;
        }

        public boolean validate() {
            return true;
        }
    }
}

