/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensextant.geodesy.MGRS;

@ComponentName(value="MGRS")
@ComponentDescription(value="Extract MGRS coordinates, optionally ignoring MGRS coordinates that could be dates")
@SettingsClass(value=Settings.class)
public class Mgrs
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations("entity/coordinate", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.isIgnoreDates());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private final boolean ignoreDates;

        public Settings() {
            this.ignoreDates = false;
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="ignoreDates") boolean ignoreDates) {
            this.ignoreDates = ignoreDates;
        }

        @Description(value="Should MGRS co-ordinates that could also be valid dates be ignored", defaultValue="false")
        public boolean isIgnoreDates() {
            return this.ignoreDates;
        }

        public boolean validate() {
            return true;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private static final Pattern mgrsPattern = Pattern.compile("\\b(([1-9]|[1-5][0-9]|60)\\h*([C-HJ-NP-X])\\h*[A-HJ-NP-Z][A-HJ-NP-V]\\h*(([0-9]{5}\\h*[0-9]{5})|([0-9]{4}\\h*[0-9]{4})|([0-9]{3}\\h*[0-9]{3})|([0-9]{2}\\h*[0-9]{2})|([0-9]\\h*[0-9])))\\b");
        private static final Pattern datesPattern = Pattern.compile("([0-2]?[0-9]|3[01])\\h*(JAN|FEB|MAR|JUN|JUL|SEP|DEC)\\h*([0-9]{2}|[0-9]{4})");
        private final boolean ignoreDates;

        public Processor(boolean ignoreDates) {
            this.ignoreDates = ignoreDates;
        }

        protected void process(Text content) {
            Matcher m = mgrsPattern.matcher((CharSequence)content.getData());
            while (m.find()) {
                Matcher mDates;
                String coordinates = m.group();
                if (this.ignoreDates && (mDates = datesPattern.matcher(coordinates)).matches()) {
                    this.log().info("Discarding possible MGRS coordinate {} as it resembles a date", (Object)coordinates);
                    continue;
                }
                ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(m.start(), m.end())).withType("entity/coordinate")).withProperty("coordinateType", (Object)"MGRS")).withProperty("value", (Object)coordinates.replaceAll("\\h+", ""))).withPropertyIfPresent("geojson", this.getGeoJson(coordinates))).save();
            }
        }

        private Optional<String> getGeoJson(String coordinate) {
            try {
                MGRS mgrs = new MGRS(coordinate);
                return Optional.of("{\"type\":\"Polygon\",\"coordinates\":[[[" + mgrs.getBoundingBox().getEastLon().inDegrees() + "," + mgrs.getBoundingBox().getNorthLat().inDegrees() + "],[" + mgrs.getBoundingBox().getWestLon().inDegrees() + "," + mgrs.getBoundingBox().getNorthLat().inDegrees() + "],[" + mgrs.getBoundingBox().getWestLon().inDegrees() + "," + mgrs.getBoundingBox().getSouthLat().inDegrees() + "],[" + mgrs.getBoundingBox().getEastLon().inDegrees() + "," + mgrs.getBoundingBox().getSouthLat().inDegrees() + "],[" + mgrs.getBoundingBox().getEastLon().inDegrees() + "," + mgrs.getBoundingBox().getNorthLat().inDegrees() + "]]]}");
            }
            catch (IllegalArgumentException e) {
                this.log().warn("Couldn't parse MGRS co-ordinate", (Throwable)e);
                return Optional.empty();
            }
        }
    }
}

