/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors.geonames;

import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import io.annot8.components.geo.processors.geonames.GeoNamesAdditionalProperties;
import io.annot8.components.geo.processors.geonames.GeoNamesBean;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GeoNamesUtils {
    private GeoNamesUtils() {
    }

    public static Map<Set<String>, Map<String, Object>> loadGazetteer(File f, GeoNamesAdditionalProperties additionalProperties, boolean geoJson, int minPopulation) throws IOException {
        HashMap<Set<String>, Map<String, Object>> gazetteer = new HashMap<Set<String>, Map<String, Object>>();
        try (FileReader reader = new FileReader(f);){
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withSeparator('\t').withIgnoreQuotations(true).withType(GeoNamesBean.class).build();
            for (GeoNamesBean bean : csvToBean) {
                if (bean.getPopulation() == null ? minPopulation > 0 : bean.getPopulation() < (long)minPopulation) continue;
                HashSet<String> names = new HashSet<String>();
                names.add(bean.getName());
                names.add(bean.getAsciiName());
                names.addAll(bean.getAlternateNames());
                HashMap<String, Object> props = new HashMap<String, Object>();
                switch (additionalProperties) {
                    case ALL: {
                        GeoNamesUtils.putIfNotNull(props, "identifier", bean.getGeonameId());
                        GeoNamesUtils.putIfNotNull(props, "lastUpdated", bean.getModificationDate());
                    }
                    case EXTENDED: {
                        GeoNamesUtils.putIfNotNull(props, "admin1Code", bean.getAdmin1Code());
                        GeoNamesUtils.putIfNotNull(props, "admin2Code", bean.getAdmin2Code());
                        GeoNamesUtils.putIfNotNull(props, "admin3Code", bean.getAdmin3Code());
                        GeoNamesUtils.putIfNotNull(props, "admin4Code", bean.getAdmin4Code());
                        GeoNamesUtils.putIfNotNull(props, "cc2", bean.getCc2());
                        if (bean.getDem() != null && !bean.getDem().equals(-9999)) {
                            props.put("dem", bean.getPopulation());
                        }
                        GeoNamesUtils.putIfNotNull(props, "elevation", bean.getElevation());
                        GeoNamesUtils.putIfNotNull(props, "featureClass", bean.getFeatureClass());
                        GeoNamesUtils.putIfNotNull(props, "featureCode", bean.getFeatureCode());
                        GeoNamesUtils.putIfNotNull(props, "population", bean.getPopulation());
                        GeoNamesUtils.putIfNotNull(props, "timezone", bean.getTimezone());
                    }
                    case BASIC: {
                        GeoNamesUtils.putIfNotNull(props, "country", bean.getCountryCode());
                        GeoNamesUtils.putIfNotNull(props, "latitude", bean.getLatitude());
                        GeoNamesUtils.putIfNotNull(props, "longitude", bean.getLongitude());
                    }
                }
                if (geoJson && bean.getLatitude() != null && bean.getLongitude() != null) {
                    props.put("geojson", "{\"type\":\"Point\",\"coordinates\":[" + bean.getLongitude() + "," + bean.getLatitude() + "]}");
                }
                gazetteer.put(names, props);
            }
        }
        return gazetteer;
    }

    private static void putIfNotNull(Map<String, Object> m, String k, Object v) {
        if (v != null) {
            m.put(k, v);
        }
    }

    private static void putIfNotNull(Map<String, Object> m, String k, String s) {
        if (s != null && !s.isBlank()) {
            m.put(k, s);
        }
    }

    private static void putIfNotNull(Map<String, Object> m, String k, List<String> l) {
        if (l == null || l.isEmpty()) {
            return;
        }
        List fl = l.stream().filter(s -> !s.isBlank()).collect(Collectors.toList());
        if (!fl.isEmpty()) {
            m.put(k, fl);
        }
    }
}

