/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.groups.processors;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ComponentName(value="Filter Groups by Property")
@ComponentDescription(value="Remove all groups with a given property value")
@ComponentTags(value={"groups", "filter", "property", "cleaning"})
@SettingsClass(value=Settings.class)
public class FilterGroupsByProperty
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getKey(), settings.getValue());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Content.class).withDeletesAnnotations("*", Bounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key;
        private Object value;

        public Settings() {
            this.key = null;
            this.value = null;
        }

        public Settings(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Description(value="Property key to check")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Description(value="Property value to check")
        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean validate() {
            return this.key != null;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String key;
        private final Object value;

        public Processor(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public ProcessorResponse process(Item item) {
            List toRemove = item.getGroups().getAll().filter(a -> {
                Optional opt = a.getProperties().get(this.key);
                return opt.isPresent() && opt.get().equals(this.value);
            }).collect(Collectors.toList());
            this.log().info("Removing {} groups from Item {}", (Object)toRemove.size(), (Object)item.getId());
            item.getGroups().delete(toRemove);
            return ProcessorResponse.ok();
        }
    }
}

