/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.opennlp.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.common.data.utils.SortUtils;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;

@ComponentName(value="OpenNLP Part of Speech")
@ComponentDescription(value="Annotate parts of speech identified by OpenNLP's POS detector")
@SettingsClass(value=Settings.class)
public class POS
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        InputStream model;
        if (settings.getModel() == null) {
            model = POS.class.getResourceAsStream("en-pos-maxent.bin");
        } else {
            try {
                model = new FileInputStream(settings.getModel());
            }
            catch (IOException e) {
                throw new BadConfigurationException("Could not read POS model");
            }
        }
        return new Processor(model);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withProcessesAnnotations("grammar/sentence", SpanBounds.class).withProcessesAnnotations("grammar/wordToken", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private File model;

        public boolean validate() {
            return true;
        }

        @Description(value="OpenNLP Part of Speech Model (or null to use default)")
        public File getModel() {
            return this.model;
        }

        public void setModel(File model) {
            this.model = model;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private POSTaggerME detector;

        public Processor(InputStream model) {
            try {
                this.detector = new POSTaggerME(new POSModel(model));
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Cannot read POS model", (Throwable)ioe);
            }
        }

        protected void process(Text content) {
            content.getAnnotations().getByBoundsAndType(SpanBounds.class, "grammar/sentence").forEach(s -> {
                SpanBounds sentenceBounds = (SpanBounds)s.getBounds();
                ArrayList tokens = new ArrayList();
                content.getBetween(sentenceBounds.getBegin(), sentenceBounds.getEnd()).filter(a -> "grammar/wordToken".equals(a.getType())).filter(a -> a.getBounds() instanceof SpanBounds).sorted(SortUtils.SORT_BY_SPANBOUNDS).forEach(tokens::add);
                String[] pos = this.detector.tag((String[])tokens.stream().map(b -> (String)((SpanBounds)b.getBounds(SpanBounds.class).get()).getData((Content)content).get()).toArray(String[]::new));
                for (int i = 0; i < pos.length; ++i) {
                    Annotation original = (Annotation)tokens.get(i);
                    ((Annotation.Builder)content.getAnnotations().copy(original).withProperty("pos", (Object)pos[i])).save();
                }
                content.getAnnotations().delete(tokens);
            });
        }

        public void close() {
            this.detector = null;
        }
    }
}

