/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.opennlp.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.components.opennlp.processors.POS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;

@ComponentName(value="OpenNLP Sentences")
@ComponentDescription(value="Annotate sentences identified by OpenNLP's sentence detector")
@SettingsClass(value=Settings.class)
public class Sentences
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        InputStream model;
        if (settings.getModel() == null) {
            model = POS.class.getResourceAsStream("en-sent.bin");
        } else {
            try {
                model = new FileInputStream(settings.getModel());
            }
            catch (IOException e) {
                throw new BadConfigurationException("Could not read Sentence model");
            }
        }
        return new Processor(model);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("grammar/sentence", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private File model;

        public boolean validate() {
            return true;
        }

        @Description(value="OpenNLP Sentence Model (or null to use default)")
        public File getModel() {
            return this.model;
        }

        public void setModel(File model) {
            this.model = model;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private SentenceDetectorME detector;

        public Processor(InputStream model) {
            try {
                this.detector = new SentenceDetectorME(new SentenceModel(model));
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Cannot read Sentence model", (Throwable)ioe);
            }
        }

        protected void process(Text content) {
            Span[] sentences;
            for (Span s : sentences = this.detector.sentPosDetect(this.lowerIfUpperCase((String)content.getData()))) {
                ((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(s.getStart(), s.getEnd())).withType("grammar/sentence")).withProperty("probability", (Object)s.getProb())).save();
            }
        }

        public void close() {
            this.detector = null;
        }

        private String lowerIfUpperCase(String original) {
            if (original.toUpperCase().equals(original)) {
                return original.toLowerCase();
            }
            return original;
        }
    }
}

