/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.opennlp.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.ContentBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import io.annot8.components.opennlp.processors.Tokens;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;

@ComponentName(value="OpenNLP Language Detection")
@ComponentDescription(value="Annotate tokens identified by OpenNLP's language detector")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"opennlp", "language"})
public class LanguageDetection
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        InputStream model;
        if (settings.getModel() == null) {
            model = Tokens.class.getResourceAsStream("langdetect-183.bin");
        } else {
            try {
                model = new FileInputStream(settings.getModel());
            }
            catch (IOException e) {
                throw new BadConfigurationException("Could not read Language Detection model");
            }
        }
        return new Processor(model);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/language", ContentBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private File model;

        public boolean validate() {
            return true;
        }

        @Description(value="OpenNLP Language Detection Model (or null to use default)")
        public File getModel() {
            return this.model;
        }

        public void setModel(File model) {
            this.model = model;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private LanguageDetector detector;

        public Processor(InputStream model) {
            try {
                this.detector = new LanguageDetectorME(new LanguageDetectorModel(model));
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Cannot read Language Detection model", (Throwable)ioe);
            }
        }

        protected void process(Text content) {
            Language l = this.detector.predictLanguage((CharSequence)content.getData());
            ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withType("entity/language")).withBounds((Bounds)ContentBounds.getInstance()).withProperty("language", (Object)l.getLang())).withProperty("probability", (Object)l.getConfidence())).save();
        }

        public void close() {
            this.detector = null;
        }
    }
}

