/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.opennlp.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import io.annot8.components.opennlp.processors.POS;
import io.annot8.components.opennlp.processors.PhraseChunks;
import io.annot8.components.opennlp.processors.Sentences;
import io.annot8.components.opennlp.processors.Tokens;

@ComponentName(value="OpenNLP Language Features")
@ComponentDescription(value="Uses the Sentences, Tokens, POS and PhraseChunks processors to add language features to Text")
@ComponentTags(value={"opennlp", "sentences", "tokens", "pos", "phrases"})
public class LanguageFeatures
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings noSettings) {
        return new Processor(context);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("grammar/sentence", SpanBounds.class).withCreatesAnnotations("grammar/wordToken", SpanBounds.class).withCreatesGroups("group/grammar/phrase").build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private Sentences.Processor sentences;
        private Tokens.Processor tokens;
        private POS.Processor pos;
        private PhraseChunks.Processor chunks;

        public Processor(Context context) {
            Sentences s = new Sentences();
            this.sentences = s.createComponent(context, new Sentences.Settings());
            Tokens t = new Tokens();
            this.tokens = t.createComponent(context, new Tokens.Settings());
            POS p = new POS();
            this.pos = p.createComponent(context, new POS.Settings());
            PhraseChunks c = new PhraseChunks();
            this.chunks = c.createComponent(context, new PhraseChunks.Settings());
        }

        protected void process(Text content) {
            this.sentences.process(content);
            this.tokens.process(content);
            this.pos.process(content);
            this.chunks.process(content);
        }

        public void close() {
            this.sentences.close();
            this.tokens.close();
            this.pos.close();
            this.chunks.close();
        }
    }
}

